package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.GameLocalization

/**
 *  Fields of the [GameLocalization] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#game-localization](https://api-docs.igdb.com/#game-localization)
 */
public enum class GameLocalizationField(
  public override val igdbName: String,
) : IgdbField<GameLocalization> {
  /**
   *  Field "id" of the [GameLocalization] IGDB entity. Matches [GameLocalization.id].
   */
  ID("id"),
  /**
   *  Field "name" of the [GameLocalization] IGDB entity. Matches [GameLocalization.name].
   */
  NAME("name"),
  /**
   *  Field "cover" of the [GameLocalization] IGDB entity. Matches [GameLocalization.cover].
   */
  COVER("cover"),
  /**
   *  Field "game" of the [GameLocalization] IGDB entity. Matches [GameLocalization.game].
   */
  GAME("game"),
  /**
   *  Field "region" of the [GameLocalization] IGDB entity. Matches [GameLocalization.region].
   */
  REGION("region"),
  /**
   *  Field "created_at" of the [GameLocalization] IGDB entity. Matches
   * [GameLocalization.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "updated_at" of the [GameLocalization] IGDB entity. Matches
   * [GameLocalization.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "checksum" of the [GameLocalization] IGDB entity. Matches [GameLocalization.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
