package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.ReleaseDate

/**
 *  Fields of the [ReleaseDate] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#release-date](https://api-docs.igdb.com/#release-date)
 */
public enum class ReleaseDateField(
  public override val igdbName: String,
) : IgdbField<ReleaseDate> {
  /**
   *  Field "id" of the [ReleaseDate] IGDB entity. Matches [ReleaseDate.id].
   */
  ID("id"),
  /**
   *  Field "category" of the [ReleaseDate] IGDB entity. Matches [ReleaseDate.category].
   */
  CATEGORY("category"),
  /**
   *  Field "created_at" of the [ReleaseDate] IGDB entity. Matches [ReleaseDate.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "date" of the [ReleaseDate] IGDB entity. Matches [ReleaseDate.date].
   */
  DATE("date"),
  /**
   *  Field "game" of the [ReleaseDate] IGDB entity. Matches [ReleaseDate.game].
   */
  GAME("game"),
  /**
   *  Field "human" of the [ReleaseDate] IGDB entity. Matches [ReleaseDate.human].
   */
  HUMAN("human"),
  /**
   *  Field "m" of the [ReleaseDate] IGDB entity. Matches [ReleaseDate.m].
   */
  M("m"),
  /**
   *  Field "platform" of the [ReleaseDate] IGDB entity. Matches [ReleaseDate.platform].
   */
  PLATFORM("platform"),
  /**
   *  Field "region" of the [ReleaseDate] IGDB entity. Matches [ReleaseDate.region].
   */
  REGION("region"),
  /**
   *  Field "updated_at" of the [ReleaseDate] IGDB entity. Matches [ReleaseDate.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "y" of the [ReleaseDate] IGDB entity. Matches [ReleaseDate.y].
   */
  Y("y"),
  /**
   *  Field "checksum" of the [ReleaseDate] IGDB entity. Matches [ReleaseDate.checksum].
   */
  CHECKSUM("checksum"),
  /**
   *  Field "status" of the [ReleaseDate] IGDB entity. Matches [ReleaseDate.status].
   */
  STATUS("status"),
  ;

  override fun toString(): String = igdbName
}
