package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.GameLocalization
import ru.pixnews.igdbclient.scheme.`field`.GameLocalizationField

private val _gameLocalizationFieldDslInstance: GameLocalizationFieldDsl = GameLocalizationFieldDsl()

public val GameLocalization.Companion.`field`: GameLocalizationFieldDsl
  get() = _gameLocalizationFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [GameLocalization] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#game-localization](https://api-docs.igdb.com/#game-localization)
 */
@IgdbClientDsl
public class GameLocalizationFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<GameLocalizationField, GameLocalization>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [GameLocalization] Igdb entity.
   *
   *  The value will be returned in the [GameLocalization.id] field of the response
   */
  public val id: IgdbRequestField<GameLocalization>
    get() = fieldWithId(GameLocalizationField.ID)

  /**
   *  Query for the "name" field of the [GameLocalization] Igdb entity.
   *
   *  The value will be returned in the [GameLocalization.name] field of the response
   */
  public val name: IgdbRequestField<GameLocalization>
    get() = fieldWithId(GameLocalizationField.NAME)

  /**
   *  Fields of the "cover" ([Cover][ru.pixnews.igdbclient.model.Cover]) nested IGDB entity
   */
  public val cover: CoverFieldDsl
    get() = CoverFieldDsl(fieldWithId(GameLocalizationField.COVER))

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameLocalizationField.GAME))

  /**
   *  Fields of the "region" ([Region][ru.pixnews.igdbclient.model.Region]) nested IGDB entity
   */
  public val region: RegionFieldDsl
    get() = RegionFieldDsl(fieldWithId(GameLocalizationField.REGION))

  /**
   *  Query for the "created_at" field of the [GameLocalization] Igdb entity.
   *
   *  The value will be returned in the [GameLocalization.created_at] field of the response
   */
  public val created_at: IgdbRequestField<GameLocalization>
    get() = fieldWithId(GameLocalizationField.CREATED_AT)

  /**
   *  Query for the "updated_at" field of the [GameLocalization] Igdb entity.
   *
   *  The value will be returned in the [GameLocalization.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<GameLocalization>
    get() = fieldWithId(GameLocalizationField.UPDATED_AT)

  /**
   *  Query for the "checksum" field of the [GameLocalization] Igdb entity.
   *
   *  The value will be returned in the [GameLocalization.checksum] field of the response
   */
  public val checksum: IgdbRequestField<GameLocalization>
    get() = fieldWithId(GameLocalizationField.CHECKSUM)
}
