package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.CompanyLogo

/**
 *  Fields of the [CompanyLogo] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#company-logo](https://api-docs.igdb.com/#company-logo)
 */
public enum class CompanyLogoField(
  public override val igdbName: String,
) : IgdbField<CompanyLogo> {
  /**
   *  Field "id" of the [CompanyLogo] IGDB entity. Matches [CompanyLogo.id].
   */
  ID("id"),
  /**
   *  Field "alpha_channel" of the [CompanyLogo] IGDB entity. Matches [CompanyLogo.alpha_channel].
   */
  ALPHA_CHANNEL("alpha_channel"),
  /**
   *  Field "animated" of the [CompanyLogo] IGDB entity. Matches [CompanyLogo.animated].
   */
  ANIMATED("animated"),
  /**
   *  Field "height" of the [CompanyLogo] IGDB entity. Matches [CompanyLogo.height].
   */
  HEIGHT("height"),
  /**
   *  Field "image_id" of the [CompanyLogo] IGDB entity. Matches [CompanyLogo.image_id].
   */
  IMAGE_ID("image_id"),
  /**
   *  Field "url" of the [CompanyLogo] IGDB entity. Matches [CompanyLogo.url].
   */
  URL("url"),
  /**
   *  Field "width" of the [CompanyLogo] IGDB entity. Matches [CompanyLogo.width].
   */
  WIDTH("width"),
  /**
   *  Field "checksum" of the [CompanyLogo] IGDB entity. Matches [CompanyLogo.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
