package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.CompanyWebsite

/**
 *  Fields of the [CompanyWebsite] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#company-website](https://api-docs.igdb.com/#company-website)
 */
public enum class CompanyWebsiteField(
  public override val igdbName: String,
) : IgdbField<CompanyWebsite> {
  /**
   *  Field "id" of the [CompanyWebsite] IGDB entity. Matches [CompanyWebsite.id].
   */
  ID("id"),
  /**
   *  Field "category" of the [CompanyWebsite] IGDB entity. Matches [CompanyWebsite.category].
   */
  CATEGORY("category"),
  /**
   *  Field "trusted" of the [CompanyWebsite] IGDB entity. Matches [CompanyWebsite.trusted].
   */
  TRUSTED("trusted"),
  /**
   *  Field "url" of the [CompanyWebsite] IGDB entity. Matches [CompanyWebsite.url].
   */
  URL("url"),
  /**
   *  Field "checksum" of the [CompanyWebsite] IGDB entity. Matches [CompanyWebsite.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
