package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.PlatformFamily

/**
 *  Fields of the [PlatformFamily] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#platform-family](https://api-docs.igdb.com/#platform-family)
 */
public enum class PlatformFamilyField(
  public override val igdbName: String,
) : IgdbField<PlatformFamily> {
  /**
   *  Field "id" of the [PlatformFamily] IGDB entity. Matches [PlatformFamily.id].
   */
  ID("id"),
  /**
   *  Field "name" of the [PlatformFamily] IGDB entity. Matches [PlatformFamily.name].
   */
  NAME("name"),
  /**
   *  Field "slug" of the [PlatformFamily] IGDB entity. Matches [PlatformFamily.slug].
   */
  SLUG("slug"),
  /**
   *  Field "checksum" of the [PlatformFamily] IGDB entity. Matches [PlatformFamily.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
