/*
 * Decompiled with CFR 0.152.
 */
package ru.pixnews.igdbclient.error;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.pixnews.igdbclient.IgdbResult;
import ru.pixnews.igdbclient.error.IgdbException;
import ru.pixnews.igdbclient.error.IgdbHttpErrorResponse;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0015\b\u0010\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B1\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\f\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lru/pixnews/igdbclient/error/IgdbHttpException;", "Lru/pixnews/igdbclient/error/IgdbException;", "failure", "Lru/pixnews/igdbclient/IgdbResult$Failure$HttpFailure;", "Lru/pixnews/igdbclient/error/IgdbHttpErrorResponse;", "(Lru/pixnews/igdbclient/IgdbResult$Failure$HttpFailure;)V", "Lru/pixnews/igdbclient/IgdbResult$Failure$UnknownHttpCodeFailure;", "(Lru/pixnews/igdbclient/IgdbResult$Failure$UnknownHttpCodeFailure;)V", "code", "", "httpMessage", "", "message", "response", "rawResponseBody", "", "(ILjava/lang/String;Ljava/lang/String;Lru/pixnews/igdbclient/error/IgdbHttpErrorResponse;[B)V", "getCode", "()I", "getHttpMessage", "()Ljava/lang/String;", "getMessage", "getRawResponseBody", "()[B", "getResponse", "()Lru/pixnews/igdbclient/error/IgdbHttpErrorResponse;", "igdbclient-core"})
public final class IgdbHttpException
extends IgdbException {
    private final int code;
    @NotNull
    private final String httpMessage;
    @NotNull
    private final String message;
    @Nullable
    private final IgdbHttpErrorResponse response;
    @Nullable
    private final byte[] rawResponseBody;

    public IgdbHttpException(int code, @NotNull String httpMessage, @NotNull String message, @Nullable IgdbHttpErrorResponse response, @Nullable byte[] rawResponseBody) {
        Intrinsics.checkNotNullParameter((Object)httpMessage, (String)"httpMessage");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(message);
        this.code = code;
        this.httpMessage = httpMessage;
        this.message = message;
        this.response = response;
        this.rawResponseBody = rawResponseBody;
    }

    public final int getCode() {
        return this.code;
    }

    @NotNull
    public final String getHttpMessage() {
        return this.httpMessage;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public final IgdbHttpErrorResponse getResponse() {
        return this.response;
    }

    @Nullable
    public final byte[] getRawResponseBody() {
        return this.rawResponseBody;
    }

    public IgdbHttpException(@NotNull IgdbResult.Failure.HttpFailure<IgdbHttpErrorResponse> failure) {
        Intrinsics.checkNotNullParameter(failure, (String)"failure");
        this(failure.getHttpCode(), failure.getHttpMessage(), "HTTP " + failure.getHttpCode() + " " + failure.getHttpMessage(), failure.getResponse(), failure.getRawResponseBody());
    }

    public IgdbHttpException(@NotNull IgdbResult.Failure.UnknownHttpCodeFailure failure) {
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        this(failure.getHttpCode(), failure.getHttpMessage(), "HTTP " + failure.getHttpCode() + " " + failure.getHttpMessage(), null, failure.getRawResponseBody());
    }
}

