package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Genre

/**
 *  Fields of the [Genre] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#genre](https://api-docs.igdb.com/#genre)
 */
public enum class GenreField(
  public override val igdbName: String,
) : IgdbField<Genre> {
  /**
   *  Field "id" of the [Genre] IGDB entity. Matches [Genre.id].
   */
  ID("id"),
  /**
   *  Field "created_at" of the [Genre] IGDB entity. Matches [Genre.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "name" of the [Genre] IGDB entity. Matches [Genre.name].
   */
  NAME("name"),
  /**
   *  Field "slug" of the [Genre] IGDB entity. Matches [Genre.slug].
   */
  SLUG("slug"),
  /**
   *  Field "updated_at" of the [Genre] IGDB entity. Matches [Genre.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "url" of the [Genre] IGDB entity. Matches [Genre.url].
   */
  URL("url"),
  /**
   *  Field "checksum" of the [Genre] IGDB entity. Matches [Genre.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
