package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.CompanyLogo
import ru.pixnews.igdbclient.scheme.`field`.CompanyLogoField

private val _companyLogoFieldDslInstance: CompanyLogoFieldDsl = CompanyLogoFieldDsl()

public val CompanyLogo.Companion.`field`: CompanyLogoFieldDsl
  get() = _companyLogoFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [CompanyLogo] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#company-logo](https://api-docs.igdb.com/#company-logo)
 */
@IgdbClientDsl
public class CompanyLogoFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<CompanyLogoField, CompanyLogo>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [CompanyLogo] Igdb entity.
   *
   *  The value will be returned in the [CompanyLogo.id] field of the response
   */
  public val id: IgdbRequestField<CompanyLogo>
    get() = fieldWithId(CompanyLogoField.ID)

  /**
   *  Query for the "alpha_channel" field of the [CompanyLogo] Igdb entity.
   *
   *  The value will be returned in the [CompanyLogo.alpha_channel] field of the response
   */
  public val alpha_channel: IgdbRequestField<CompanyLogo>
    get() = fieldWithId(CompanyLogoField.ALPHA_CHANNEL)

  /**
   *  Query for the "animated" field of the [CompanyLogo] Igdb entity.
   *
   *  The value will be returned in the [CompanyLogo.animated] field of the response
   */
  public val animated: IgdbRequestField<CompanyLogo>
    get() = fieldWithId(CompanyLogoField.ANIMATED)

  /**
   *  Query for the "height" field of the [CompanyLogo] Igdb entity.
   *
   *  The value will be returned in the [CompanyLogo.height] field of the response
   */
  public val height: IgdbRequestField<CompanyLogo>
    get() = fieldWithId(CompanyLogoField.HEIGHT)

  /**
   *  Query for the "image_id" field of the [CompanyLogo] Igdb entity.
   *
   *  The value will be returned in the [CompanyLogo.image_id] field of the response
   */
  public val image_id: IgdbRequestField<CompanyLogo>
    get() = fieldWithId(CompanyLogoField.IMAGE_ID)

  /**
   *  Query for the "url" field of the [CompanyLogo] Igdb entity.
   *
   *  The value will be returned in the [CompanyLogo.url] field of the response
   */
  public val url: IgdbRequestField<CompanyLogo>
    get() = fieldWithId(CompanyLogoField.URL)

  /**
   *  Query for the "width" field of the [CompanyLogo] Igdb entity.
   *
   *  The value will be returned in the [CompanyLogo.width] field of the response
   */
  public val width: IgdbRequestField<CompanyLogo>
    get() = fieldWithId(CompanyLogoField.WIDTH)

  /**
   *  Query for the "checksum" field of the [CompanyLogo] Igdb entity.
   *
   *  The value will be returned in the [CompanyLogo.checksum] field of the response
   */
  public val checksum: IgdbRequestField<CompanyLogo>
    get() = fieldWithId(CompanyLogoField.CHECKSUM)
}
