package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Cover
import ru.pixnews.igdbclient.scheme.`field`.CoverField

private val _coverFieldDslInstance: CoverFieldDsl = CoverFieldDsl()

public val Cover.Companion.`field`: CoverFieldDsl
  get() = _coverFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Cover] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#cover](https://api-docs.igdb.com/#cover)
 */
@IgdbClientDsl
public class CoverFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<CoverField, Cover>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Cover] Igdb entity.
   *
   *  The value will be returned in the [Cover.id] field of the response
   */
  public val id: IgdbRequestField<Cover>
    get() = fieldWithId(CoverField.ID)

  /**
   *  Query for the "alpha_channel" field of the [Cover] Igdb entity.
   *
   *  The value will be returned in the [Cover.alpha_channel] field of the response
   */
  public val alpha_channel: IgdbRequestField<Cover>
    get() = fieldWithId(CoverField.ALPHA_CHANNEL)

  /**
   *  Query for the "animated" field of the [Cover] Igdb entity.
   *
   *  The value will be returned in the [Cover.animated] field of the response
   */
  public val animated: IgdbRequestField<Cover>
    get() = fieldWithId(CoverField.ANIMATED)

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(CoverField.GAME))

  /**
   *  Query for the "height" field of the [Cover] Igdb entity.
   *
   *  The value will be returned in the [Cover.height] field of the response
   */
  public val height: IgdbRequestField<Cover>
    get() = fieldWithId(CoverField.HEIGHT)

  /**
   *  Query for the "image_id" field of the [Cover] Igdb entity.
   *
   *  The value will be returned in the [Cover.image_id] field of the response
   */
  public val image_id: IgdbRequestField<Cover>
    get() = fieldWithId(CoverField.IMAGE_ID)

  /**
   *  Query for the "url" field of the [Cover] Igdb entity.
   *
   *  The value will be returned in the [Cover.url] field of the response
   */
  public val url: IgdbRequestField<Cover>
    get() = fieldWithId(CoverField.URL)

  /**
   *  Query for the "width" field of the [Cover] Igdb entity.
   *
   *  The value will be returned in the [Cover.width] field of the response
   */
  public val width: IgdbRequestField<Cover>
    get() = fieldWithId(CoverField.WIDTH)

  /**
   *  Query for the "checksum" field of the [Cover] Igdb entity.
   *
   *  The value will be returned in the [Cover.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Cover>
    get() = fieldWithId(CoverField.CHECKSUM)

  /**
   *  Fields of the "game_localization"
   * ([GameLocalization][ru.pixnews.igdbclient.model.GameLocalization]) nested IGDB entity
   */
  public val game_localization: GameLocalizationFieldDsl
    get() = GameLocalizationFieldDsl(fieldWithId(CoverField.GAME_LOCALIZATION))
}
