package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.GameVideo
import ru.pixnews.igdbclient.scheme.`field`.GameVideoField

private val _gameVideoFieldDslInstance: GameVideoFieldDsl = GameVideoFieldDsl()

public val GameVideo.Companion.`field`: GameVideoFieldDsl
  get() = _gameVideoFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [GameVideo] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#game-video](https://api-docs.igdb.com/#game-video)
 */
@IgdbClientDsl
public class GameVideoFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<GameVideoField, GameVideo>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [GameVideo] Igdb entity.
   *
   *  The value will be returned in the [GameVideo.id] field of the response
   */
  public val id: IgdbRequestField<GameVideo>
    get() = fieldWithId(GameVideoField.ID)

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameVideoField.GAME))

  /**
   *  Query for the "name" field of the [GameVideo] Igdb entity.
   *
   *  The value will be returned in the [GameVideo.name] field of the response
   */
  public val name: IgdbRequestField<GameVideo>
    get() = fieldWithId(GameVideoField.NAME)

  /**
   *  Query for the "video_id" field of the [GameVideo] Igdb entity.
   *
   *  The value will be returned in the [GameVideo.video_id] field of the response
   */
  public val video_id: IgdbRequestField<GameVideo>
    get() = fieldWithId(GameVideoField.VIDEO_ID)

  /**
   *  Query for the "checksum" field of the [GameVideo] Igdb entity.
   *
   *  The value will be returned in the [GameVideo.checksum] field of the response
   */
  public val checksum: IgdbRequestField<GameVideo>
    get() = fieldWithId(GameVideoField.CHECKSUM)
}
