package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Collection

/**
 *  Fields of the [Collection] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#collection](https://api-docs.igdb.com/#collection)
 */
public enum class CollectionField(
  public override val igdbName: String,
) : IgdbField<Collection> {
  /**
   *  Field "id" of the [Collection] IGDB entity. Matches [Collection.id].
   */
  ID("id"),
  /**
   *  Field "created_at" of the [Collection] IGDB entity. Matches [Collection.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "games" of the [Collection] IGDB entity. Matches [Collection.games].
   */
  GAMES("games"),
  /**
   *  Field "name" of the [Collection] IGDB entity. Matches [Collection.name].
   */
  NAME("name"),
  /**
   *  Field "slug" of the [Collection] IGDB entity. Matches [Collection.slug].
   */
  SLUG("slug"),
  /**
   *  Field "updated_at" of the [Collection] IGDB entity. Matches [Collection.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "url" of the [Collection] IGDB entity. Matches [Collection.url].
   */
  URL("url"),
  /**
   *  Field "checksum" of the [Collection] IGDB entity. Matches [Collection.checksum].
   */
  CHECKSUM("checksum"),
  /**
   *  Field "type" of the [Collection] IGDB entity. Matches [Collection.type].
   */
  TYPE("type"),
  /**
   *  Field "as_parent_relations" of the [Collection] IGDB entity. Matches
   * [Collection.as_parent_relations].
   */
  AS_PARENT_RELATIONS("as_parent_relations"),
  /**
   *  Field "as_child_relations" of the [Collection] IGDB entity. Matches
   * [Collection.as_child_relations].
   */
  AS_CHILD_RELATIONS("as_child_relations"),
  ;

  override fun toString(): String = igdbName
}
