package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.CollectionType

/**
 *  Fields of the [CollectionType] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#collection-type](https://api-docs.igdb.com/#collection-type)
 */
public enum class CollectionTypeField(
  public override val igdbName: String,
) : IgdbField<CollectionType> {
  /**
   *  Field "id" of the [CollectionType] IGDB entity. Matches [CollectionType.id].
   */
  ID("id"),
  /**
   *  Field "name" of the [CollectionType] IGDB entity. Matches [CollectionType.name].
   */
  NAME("name"),
  /**
   *  Field "description" of the [CollectionType] IGDB entity. Matches [CollectionType.description].
   */
  DESCRIPTION("description"),
  /**
   *  Field "updated_at" of the [CollectionType] IGDB entity. Matches [CollectionType.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "created_at" of the [CollectionType] IGDB entity. Matches [CollectionType.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "checksum" of the [CollectionType] IGDB entity. Matches [CollectionType.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
