/*
 * Decompiled with CFR 0.152.
 */
package ru.pixnews.igdbclient.internal.twitch;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.pixnews.igdbclient.IgdbResult;
import ru.pixnews.igdbclient.InternalIgdbClientApi;
import ru.pixnews.igdbclient.auth.twitch.TwitchTokenPayload;
import ru.pixnews.igdbclient.auth.twitch.TwitchTokenStorage;
import ru.pixnews.igdbclient.error.IgdbException;
import ru.pixnews.igdbclient.error.IgdbHttpErrorResponse;
import ru.pixnews.igdbclient.internal.IgdbRequest;
import ru.pixnews.igdbclient.internal.RequestExecutor;
import ru.pixnews.igdbclient.internal.model.IgdbAuthToken;
import ru.pixnews.igdbclient.internal.model.TwitchToken;
import ru.pixnews.igdbclient.internal.twitch.TwitchAuthenticationRequestDecorator;
import ru.pixnews.igdbclient.internal.twitch.TwitchCredentials;
import ru.pixnews.igdbclient.internal.twitch.TwitchErrorResponse;
import ru.pixnews.igdbclient.internal.twitch.TwitchTokenFetcher;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000 \u001e2\u00020\u0001:\u0005\u001d\u001e\u001f !BL\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012#\u0010\n\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\u0002\u0010\u0010J,\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u00180\u0016\"\b\b\u0000\u0010\u0017*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0096B\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lru/pixnews/igdbclient/internal/twitch/TwitchAuthenticationRequestDecorator;", "Lru/pixnews/igdbclient/internal/RequestExecutor;", "credentials", "Lru/pixnews/igdbclient/internal/twitch/TwitchCredentials;", "tokenStorage", "Lru/pixnews/igdbclient/auth/twitch/TwitchTokenStorage;", "maxRequestRetries", "", "twitchTokenFetcher", "Lru/pixnews/igdbclient/internal/twitch/TwitchTokenFetcher;", "requestExecutorFactory", "Lkotlin/Function1;", "Lru/pixnews/igdbclient/internal/model/IgdbAuthToken;", "Lkotlin/ParameterName;", "name", "token", "(Lru/pixnews/igdbclient/internal/twitch/TwitchCredentials;Lru/pixnews/igdbclient/auth/twitch/TwitchTokenStorage;ILru/pixnews/igdbclient/internal/twitch/TwitchTokenFetcher;Lkotlin/jvm/functions/Function1;)V", "fetchTokenMutex", "Lkotlinx/coroutines/sync/Mutex;", "requestExecutorProvider", "Lru/pixnews/igdbclient/internal/twitch/TwitchAuthenticationRequestDecorator$CachedRequestExecutor;", "invoke", "Lru/pixnews/igdbclient/IgdbResult;", "T", "Lru/pixnews/igdbclient/error/IgdbHttpErrorResponse;", "", "request", "Lru/pixnews/igdbclient/internal/IgdbRequest;", "(Lru/pixnews/igdbclient/internal/IgdbRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "CachedRequestExecutor", "Companion", "RequestTokenException", "SingleRequestExecutor", "TokenPayloadWithExecutor", "igdbclient-core"})
@InternalIgdbClientApi
public final class TwitchAuthenticationRequestDecorator
implements RequestExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TwitchCredentials credentials;
    @NotNull
    private final TwitchTokenStorage tokenStorage;
    private final int maxRequestRetries;
    @NotNull
    private final TwitchTokenFetcher twitchTokenFetcher;
    @NotNull
    private final Mutex fetchTokenMutex;
    @NotNull
    private final CachedRequestExecutor requestExecutorProvider;
    public static final int MAX_COMMIT_FRESH_TOKEN_ATTEMPTS = 3;
    @NotNull
    private static final Companion.dummyRequestExecutor.1 dummyRequestExecutor = new RequestExecutor(){

        public <T> Object invoke(IgdbRequest request2, Continuation<? super IgdbResult<? extends T, IgdbHttpErrorResponse>> $completion) {
            return new IgdbResult.Failure.UnknownFailure(null);
        }
    };

    public TwitchAuthenticationRequestDecorator(@NotNull TwitchCredentials credentials2, @NotNull TwitchTokenStorage tokenStorage, int maxRequestRetries, @NotNull TwitchTokenFetcher twitchTokenFetcher, @NotNull Function1<? super IgdbAuthToken, ? extends RequestExecutor> requestExecutorFactory2) {
        Intrinsics.checkNotNullParameter((Object)credentials2, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)tokenStorage, (String)"tokenStorage");
        Intrinsics.checkNotNullParameter((Object)twitchTokenFetcher, (String)"twitchTokenFetcher");
        Intrinsics.checkNotNullParameter(requestExecutorFactory2, (String)"requestExecutorFactory");
        this.credentials = credentials2;
        this.tokenStorage = tokenStorage;
        this.maxRequestRetries = maxRequestRetries;
        this.twitchTokenFetcher = twitchTokenFetcher;
        this.fetchTokenMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.requestExecutorProvider = new CachedRequestExecutor(this.credentials, requestExecutorFactory2);
    }

    public /* synthetic */ TwitchAuthenticationRequestDecorator(TwitchCredentials twitchCredentials, TwitchTokenStorage twitchTokenStorage, int n, TwitchTokenFetcher twitchTokenFetcher, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 3;
        }
        this(twitchCredentials, twitchTokenStorage, n, twitchTokenFetcher, (Function1<? super IgdbAuthToken, ? extends RequestExecutor>)function1);
    }

    @Override
    @Nullable
    public <T> Object invoke(@NotNull IgdbRequest request2, @NotNull Continuation<? super IgdbResult<? extends T, IgdbHttpErrorResponse>> $completion) {
        return new SingleRequestExecutor(this, request2, 0, 0, 6, null).execute($completion);
    }

    public static final /* synthetic */ Mutex access$getFetchTokenMutex$p(TwitchAuthenticationRequestDecorator $this) {
        return $this.fetchTokenMutex;
    }

    public static final /* synthetic */ TwitchTokenStorage access$getTokenStorage$p(TwitchAuthenticationRequestDecorator $this) {
        return $this.tokenStorage;
    }

    public static final /* synthetic */ CachedRequestExecutor access$getRequestExecutorProvider$p(TwitchAuthenticationRequestDecorator $this) {
        return $this.requestExecutorProvider;
    }

    public static final /* synthetic */ TwitchTokenFetcher access$getTwitchTokenFetcher$p(TwitchAuthenticationRequestDecorator $this) {
        return $this.twitchTokenFetcher;
    }

    public static final /* synthetic */ TwitchCredentials access$getCredentials$p(TwitchAuthenticationRequestDecorator $this) {
        return $this.credentials;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B2\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012#\u0010\u0004\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\rH\u0086B\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0004\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lru/pixnews/igdbclient/internal/twitch/TwitchAuthenticationRequestDecorator$CachedRequestExecutor;", "", "twitchCredentials", "Lru/pixnews/igdbclient/internal/twitch/TwitchCredentials;", "requestExecutorFactory", "Lkotlin/Function1;", "Lru/pixnews/igdbclient/internal/model/IgdbAuthToken;", "Lkotlin/ParameterName;", "name", "token", "Lru/pixnews/igdbclient/internal/RequestExecutor;", "(Lru/pixnews/igdbclient/internal/twitch/TwitchCredentials;Lkotlin/jvm/functions/Function1;)V", "cachedTokenPayload", "Lru/pixnews/igdbclient/auth/twitch/TwitchTokenPayload;", "exeutor", "lock", "Lkotlinx/coroutines/sync/Mutex;", "invoke", "tokenPayload", "(Lru/pixnews/igdbclient/auth/twitch/TwitchTokenPayload;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "igdbclient-core"})
    @SourceDebugExtension(value={"SMAP\nTwitchAuthenticationRequestDecorator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TwitchAuthenticationRequestDecorator.kt\nru/pixnews/igdbclient/internal/twitch/TwitchAuthenticationRequestDecorator$CachedRequestExecutor\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,199:1\n116#2,9:200\n*S KotlinDebug\n*F\n+ 1 TwitchAuthenticationRequestDecorator.kt\nru/pixnews/igdbclient/internal/twitch/TwitchAuthenticationRequestDecorator$CachedRequestExecutor\n*L\n118#1:200,9\n*E\n"})
    private static final class CachedRequestExecutor {
        @NotNull
        private final TwitchCredentials twitchCredentials;
        @NotNull
        private final Function1<IgdbAuthToken, RequestExecutor> requestExecutorFactory;
        @NotNull
        private final Mutex lock;
        @NotNull
        private TwitchTokenPayload cachedTokenPayload;
        @NotNull
        private RequestExecutor exeutor;

        public CachedRequestExecutor(@NotNull TwitchCredentials twitchCredentials, @NotNull Function1<? super IgdbAuthToken, ? extends RequestExecutor> requestExecutorFactory2) {
            Intrinsics.checkNotNullParameter((Object)twitchCredentials, (String)"twitchCredentials");
            Intrinsics.checkNotNullParameter(requestExecutorFactory2, (String)"requestExecutorFactory");
            this.twitchCredentials = twitchCredentials;
            this.requestExecutorFactory = requestExecutorFactory2;
            this.lock = MutexKt.Mutex$default((boolean)false, (int)1, null);
            this.cachedTokenPayload = TwitchTokenPayload.Companion.getNO_TOKEN();
            this.exeutor = dummyRequestExecutor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Nullable
        public final Object invoke(@NotNull TwitchTokenPayload var1_1, @NotNull Continuation<? super RequestExecutor> $completion) {
            if (!($completion instanceof invoke.1)) ** GOTO lbl-1000
            var16_3 = $completion;
            if ((var16_3.label & -2147483648) != 0) {
                var16_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ CachedRequestExecutor this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.invoke(null, (Continuation<? super RequestExecutor>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$withLock_u24default$iv = this.lock;
                    owner$iv = null;
                    $i$f$withLock = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = tokenPayload;
                    $continuation.L$2 = $this$withLock_u24default$iv;
                    $continuation.label = 1;
                    v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                    if (v0 == var17_5) {
                        return var17_5;
                    }
                    ** GOTO lbl32
                }
                case 1: {
                    $i$f$withLock = false;
                    owner$iv = null;
                    $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                    tokenPayload = (TwitchTokenPayload)$continuation.L$1;
                    this = (CachedRequestExecutor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl32:
                    // 2 sources

                    try {
                        $i$a$-withLock$default-TwitchAuthenticationRequestDecorator$CachedRequestExecutor$invoke$2 = false;
                        if (Intrinsics.areEqual((Object)tokenPayload, (Object)this.cachedTokenPayload) && !Intrinsics.areEqual((Object)this.exeutor, (Object)TwitchAuthenticationRequestDecorator.access$getDummyRequestExecutor$cp())) {
                            var14_11 = this.exeutor;
                            return var14_11;
                        }
                        v1 = ru.pixnews.igdbclient.internal.twitch.TwitchAuthenticationRequestDecorator$Companion.access$deserializeToken(TwitchAuthenticationRequestDecorator.Companion, tokenPayload);
                        v2 = twitchToken = v1 != null ? ru.pixnews.igdbclient.internal.twitch.TwitchAuthenticationRequestDecorator$Companion.access$toIgdbToken(TwitchAuthenticationRequestDecorator.Companion, v1, this.twitchCredentials) : null;
                        if (twitchToken != null) {
                            var8_13 = this.requestExecutorFactory.invoke((Object)twitchToken);
                            it = (RequestExecutor)var8_13;
                            $i$a$-also-TwitchAuthenticationRequestDecorator$CachedRequestExecutor$invoke$2$1 = false;
                            this.exeutor = it;
                            this.cachedTokenPayload = tokenPayload;
                            var13_16 = var8_13;
                            return var13_16;
                        }
                        var12_17 = null;
                        return var12_17;
                    }
                    finally {
                        $this$withLock_u24default$iv.unlock(owner$iv);
                    }
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0006\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t*\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\tH\u0002J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\f*\u00020\nH\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lru/pixnews/igdbclient/internal/twitch/TwitchAuthenticationRequestDecorator$Companion;", "", "()V", "MAX_COMMIT_FRESH_TOKEN_ATTEMPTS", "", "dummyRequestExecutor", "ru/pixnews/igdbclient/internal/twitch/TwitchAuthenticationRequestDecorator$Companion$dummyRequestExecutor$1", "Lru/pixnews/igdbclient/internal/twitch/TwitchAuthenticationRequestDecorator$Companion$dummyRequestExecutor$1;", "asIgdbResult", "Lru/pixnews/igdbclient/IgdbResult;", "Lru/pixnews/igdbclient/auth/twitch/TwitchTokenPayload;", "Lru/pixnews/igdbclient/error/IgdbHttpErrorResponse;", "Lru/pixnews/igdbclient/internal/model/TwitchToken;", "Lru/pixnews/igdbclient/internal/twitch/TwitchErrorResponse;", "deserializeToken", "is401UnauthorizedFailure", "", "toIgdbToken", "Lru/pixnews/igdbclient/internal/model/IgdbAuthToken;", "credentials", "Lru/pixnews/igdbclient/internal/twitch/TwitchCredentials;", "igdbclient-core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean is401UnauthorizedFailure(IgdbResult<?, ?> $this$is401UnauthorizedFailure) {
            return $this$is401UnauthorizedFailure instanceof IgdbResult.Failure.HttpFailure && ((IgdbResult.Failure.HttpFailure)$this$is401UnauthorizedFailure).getHttpCode() == 401;
        }

        private final TwitchToken deserializeToken(TwitchTokenPayload $this$deserializeToken) {
            TwitchToken twitchToken;
            if ($this$deserializeToken.isEmpty()) {
                return null;
            }
            try {
                TwitchToken token = TwitchToken.Companion.decode$igdbclient_core($this$deserializeToken.getPayload());
                twitchToken = ((CharSequence)token.getAccessToken()).length() > 0 ? token : null;
            }
            catch (IOException exception) {
                twitchToken = null;
            }
            return twitchToken;
        }

        private final IgdbAuthToken toIgdbToken(TwitchToken $this$toIgdbToken, TwitchCredentials credentials2) {
            return new IgdbAuthToken(credentials2, $this$toIgdbToken){
                private final String clientId;
                private final String token;
                {
                    this.clientId = $credentials.getClientId();
                    this.token = $receiver.getAccessToken();
                }

                public String getClientId() {
                    return this.clientId;
                }

                public String getToken() {
                    return this.token;
                }
            };
        }

        private final IgdbResult<TwitchTokenPayload, IgdbHttpErrorResponse> asIgdbResult(IgdbResult<TwitchToken, TwitchErrorResponse> $this$asIgdbResult) {
            IgdbResult igdbResult;
            IgdbResult igdbResult2 = $this$asIgdbResult;
            if (igdbResult2 instanceof IgdbResult.Success) {
                igdbResult = new IgdbResult.Success<TwitchTokenPayload>(new TwitchTokenPayload(TwitchToken.Companion.encode$igdbclient_core((TwitchToken)((IgdbResult.Success)$this$asIgdbResult).getValue()), 0, 2, null));
            } else if (igdbResult2 instanceof IgdbResult.Failure.ApiFailure) {
                igdbResult = $this$asIgdbResult;
            } else if (igdbResult2 instanceof IgdbResult.Failure.NetworkFailure) {
                igdbResult = $this$asIgdbResult;
            } else if (igdbResult2 instanceof IgdbResult.Failure.UnknownFailure) {
                igdbResult = $this$asIgdbResult;
            } else if (igdbResult2 instanceof IgdbResult.Failure.UnknownHttpCodeFailure) {
                igdbResult = $this$asIgdbResult;
            } else if (igdbResult2 instanceof IgdbResult.Failure.HttpFailure) {
                IgdbHttpErrorResponse igdbHttpErrorResponse;
                int n = ((IgdbResult.Failure.HttpFailure)$this$asIgdbResult).getHttpCode();
                String string = ((IgdbResult.Failure.HttpFailure)$this$asIgdbResult).getHttpMessage();
                TwitchErrorResponse twitchErrorResponse = (TwitchErrorResponse)((IgdbResult.Failure.HttpFailure)$this$asIgdbResult).getResponse();
                if (twitchErrorResponse != null) {
                    TwitchErrorResponse twitchResponse = twitchErrorResponse;
                    boolean bl = false;
                    igdbHttpErrorResponse = new IgdbHttpErrorResponse(CollectionsKt.listOf((Object)new IgdbHttpErrorResponse.Message(twitchResponse.getStatus(), twitchResponse.getMessage(), "Twitch error")));
                } else {
                    igdbHttpErrorResponse = null;
                }
                IgdbHttpErrorResponse igdbHttpErrorResponse2 = igdbHttpErrorResponse;
                byte[] byArray = ((IgdbResult.Failure.HttpFailure)$this$asIgdbResult).getRawResponseBody();
                List<Pair<String, String>> list = ((IgdbResult.Failure.HttpFailure)$this$asIgdbResult).getRawResponseHeaders();
                igdbResult = new IgdbResult.Failure.HttpFailure<IgdbHttpErrorResponse>(n, string, igdbHttpErrorResponse2, list, byArray);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return igdbResult;
        }

        public static final /* synthetic */ boolean access$is401UnauthorizedFailure(Companion $this, IgdbResult $receiver) {
            return $this.is401UnauthorizedFailure($receiver);
        }

        public static final /* synthetic */ IgdbResult access$asIgdbResult(Companion $this, IgdbResult $receiver) {
            return $this.asIgdbResult($receiver);
        }

        public static final /* synthetic */ TwitchToken access$deserializeToken(Companion $this, TwitchTokenPayload $receiver) {
            return $this.deserializeToken($receiver);
        }

        public static final /* synthetic */ IgdbAuthToken access$toIgdbToken(Companion $this, TwitchToken $receiver, TwitchCredentials credentials2) {
            return $this.toIgdbToken($receiver, credentials2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lru/pixnews/igdbclient/internal/twitch/TwitchAuthenticationRequestDecorator$RequestTokenException;", "Lru/pixnews/igdbclient/error/IgdbException;", "message", "", "(Ljava/lang/String;)V", "igdbclient-core"})
    public static final class RequestTokenException
    extends IgdbException {
        public RequestTokenException(@Nullable String message) {
            super(message);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\fH\u0086@\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\fH\u0082@\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lru/pixnews/igdbclient/internal/twitch/TwitchAuthenticationRequestDecorator$SingleRequestExecutor;", "T", "", "request", "Lru/pixnews/igdbclient/internal/IgdbRequest;", "maxFetchTokenAttempts", "", "maxRequestRetries", "(Lru/pixnews/igdbclient/internal/twitch/TwitchAuthenticationRequestDecorator;Lru/pixnews/igdbclient/internal/IgdbRequest;II)V", "fetchTokenRequests", "requests", "execute", "Lru/pixnews/igdbclient/IgdbResult;", "Lru/pixnews/igdbclient/error/IgdbHttpErrorResponse;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFreshToken", "Lru/pixnews/igdbclient/internal/twitch/TwitchAuthenticationRequestDecorator$TokenPayloadWithExecutor;", "igdbclient-core"})
    @SourceDebugExtension(value={"SMAP\nTwitchAuthenticationRequestDecorator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TwitchAuthenticationRequestDecorator.kt\nru/pixnews/igdbclient/internal/twitch/TwitchAuthenticationRequestDecorator$SingleRequestExecutor\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,199:1\n116#2,10:200\n*S KotlinDebug\n*F\n+ 1 TwitchAuthenticationRequestDecorator.kt\nru/pixnews/igdbclient/internal/twitch/TwitchAuthenticationRequestDecorator$SingleRequestExecutor\n*L\n57#1:200,10\n*E\n"})
    private final class SingleRequestExecutor<T> {
        @NotNull
        private final IgdbRequest request;
        private final int maxFetchTokenAttempts;
        private final int maxRequestRetries;
        private int requests;
        private int fetchTokenRequests;
        final /* synthetic */ TwitchAuthenticationRequestDecorator this$0;

        public SingleRequestExecutor(@NotNull TwitchAuthenticationRequestDecorator this$0, IgdbRequest request2, int maxFetchTokenAttempts, int maxRequestRetries) {
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            this.this$0 = this$0;
            this.request = request2;
            this.maxFetchTokenAttempts = maxFetchTokenAttempts;
            this.maxRequestRetries = maxRequestRetries;
        }

        public /* synthetic */ SingleRequestExecutor(TwitchAuthenticationRequestDecorator twitchAuthenticationRequestDecorator, IgdbRequest igdbRequest, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = twitchAuthenticationRequestDecorator.maxRequestRetries;
            }
            if ((n3 & 4) != 0) {
                n2 = twitchAuthenticationRequestDecorator.maxRequestRetries;
            }
            this(twitchAuthenticationRequestDecorator, igdbRequest, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Nullable
        public final Object execute(@NotNull Continuation<? super IgdbResult<? extends T, IgdbHttpErrorResponse>> $completion) {
            if (!($completion instanceof execute.1)) ** GOTO lbl-1000
            var10_2 = $completion;
            if ((var10_2.label & -2147483648) != 0) {
                var10_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ SingleRequestExecutor<T> this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute((Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    lastResponse = new IgdbResult.Failure.UnknownFailure(null);
lbl13:
                    // 2 sources

                    while (this.requests < this.maxRequestRetries) {
                        $this$withLock_u24default$iv = TwitchAuthenticationRequestDecorator.access$getFetchTokenMutex$p(this.this$0);
                        owner$iv = null;
                        $i$f$withLock = false;
                        $continuation.L$0 = this;
                        $continuation.L$1 = $this$withLock_u24default$iv;
                        $continuation.label = 1;
                        v0 = $this$withLock_u24default$iv.lock((Object)owner$iv, (Continuation)$continuation);
                        if (v0 == var11_4) {
                            return var11_4;
                        }
                        ** GOTO lbl34
                    }
                    break;
                }
                case 1: {
                    $i$f$withLock = false;
                    owner$iv = null;
                    $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                    this = (SingleRequestExecutor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl34:
                    // 3 sources

                    $i$a$-withLock$default-TwitchAuthenticationRequestDecorator$SingleRequestExecutor$execute$getTokenResult$1 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = $this$withLock_u24default$iv;
                    $continuation.label = 2;
                    v1 = this.getFreshToken((Continuation<IgdbResult<TokenPayloadWithExecutor, IgdbHttpErrorResponse>>)$continuation);
                    ** if (v1 != var11_4) goto lbl42
lbl41:
                    // 1 sources

                    return var11_4;
lbl42:
                    // 1 sources

                    ** GOTO lbl53
                }
                case 2: {
                    $i$f$withLock = false;
                    $i$a$-withLock$default-TwitchAuthenticationRequestDecorator$SingleRequestExecutor$execute$getTokenResult$1 = false;
                    owner$iv = null;
                    $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                    this = (SingleRequestExecutor)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl53:
                        // 2 sources

                        var8_13 = (IgdbResult)v1;
                    }
                    catch (Throwable var7_12) {
                        throw var7_12;
                    }
                    finally {
                        $this$withLock_u24default$iv.unlock(owner$iv);
                    }
                    owner$iv = getTokenResult = var8_13;
                    if (!(owner$iv instanceof IgdbResult.Success)) {
                        if (owner$iv instanceof IgdbResult.Failure) {
                            return getTokenResult;
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    var4_7 = (TokenPayloadWithExecutor)((IgdbResult.Success)getTokenResult).getValue();
                    tokenPayload = var4_7.component1();
                    executor = var4_7.component2();
                    $continuation.L$0 = this;
                    $continuation.L$1 = tokenPayload;
                    $continuation.label = 3;
                    v2 = executor.invoke(this.request, $continuation);
                    if (v2 == var11_4) {
                        return var11_4;
                    }
                    ** GOTO lbl80
                }
                case 3: {
                    tokenPayload = (TwitchTokenPayload)$continuation.L$1;
                    this = (SingleRequestExecutor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl80:
                    // 2 sources

                    if (!ru.pixnews.igdbclient.internal.twitch.TwitchAuthenticationRequestDecorator$Companion.access$is401UnauthorizedFailure(TwitchAuthenticationRequestDecorator.Companion, lastResponse = (IgdbResult)v2)) {
                        return lastResponse;
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = lastResponse;
                    $continuation.label = 4;
                    v3 = TwitchAuthenticationRequestDecorator.access$getTokenStorage$p(this.this$0).updateToken(tokenPayload, TwitchTokenPayload.Companion.getNO_TOKEN(), (Continuation<? super Boolean>)$continuation);
                    if (v3 == var11_4) {
                        return var11_4;
                    }
                    ** GOTO lbl94
                }
                case 4: {
                    lastResponse = (IgdbResult)$continuation.L$1;
                    this = (SingleRequestExecutor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl94:
                    // 2 sources

                    ++this.requests;
                    ** GOTO lbl13
                }
            }
            return lastResponse;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object getFreshToken(Continuation<? super IgdbResult<TokenPayloadWithExecutor, IgdbHttpErrorResponse>> $completion) {
            if (!($completion instanceof getFreshToken.1)) ** GOTO lbl-1000
            var13_2 = $completion;
            if ((var13_2.label & -2147483648) != 0) {
                var13_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ SingleRequestExecutor<T> this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return SingleRequestExecutor.access$getFreshToken(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var2_5 = 3;
                    var3_6 = this.this$0;
                    var4_7 = 0;
lbl15:
                    // 2 sources

                    while (var4_7 < var2_5) {
                        $i$a$-repeat-TwitchAuthenticationRequestDecorator$SingleRequestExecutor$getFreshToken$2 = false;
                        $continuation.L$0 = this;
                        $continuation.L$1 = var3_6;
                        $continuation.I$0 = var2_5;
                        $continuation.I$1 = var4_7;
                        $continuation.label = 1;
                        v0 = TwitchAuthenticationRequestDecorator.access$getTokenStorage$p(var3_6).getToken((Continuation<? super TwitchTokenPayload>)$continuation);
                        if (v0 == var14_4) {
                            return var14_4;
                        }
                        ** GOTO lbl35
                    }
                    break;
                }
                case 1: {
                    $i$a$-repeat-TwitchAuthenticationRequestDecorator$SingleRequestExecutor$getFreshToken$2 = false;
                    var4_7 = $continuation.I$1;
                    var2_5 = $continuation.I$0;
                    var3_6 = (TwitchAuthenticationRequestDecorator)$continuation.L$1;
                    this = (SingleRequestExecutor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl35:
                    // 2 sources

                    storedTokenPayload = (TwitchTokenPayload)v0;
                    $continuation.L$0 = this;
                    $continuation.L$1 = var3_6;
                    $continuation.L$2 = storedTokenPayload;
                    $continuation.I$0 = var2_5;
                    $continuation.I$1 = var4_7;
                    $continuation.label = 2;
                    v1 = TwitchAuthenticationRequestDecorator.access$getRequestExecutorProvider$p(var3_6).invoke(storedTokenPayload, (Continuation<? super RequestExecutor>)$continuation);
                    if (v1 == var14_4) {
                        return var14_4;
                    }
                    ** GOTO lbl55
                }
                case 2: {
                    $i$a$-repeat-TwitchAuthenticationRequestDecorator$SingleRequestExecutor$getFreshToken$2 = false;
                    var4_7 = $continuation.I$1;
                    var2_5 = $continuation.I$0;
                    storedTokenPayload = (TwitchTokenPayload)$continuation.L$2;
                    var3_6 = (TwitchAuthenticationRequestDecorator)$continuation.L$1;
                    this = (SingleRequestExecutor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl55:
                    // 2 sources

                    v2 = (RequestExecutor)v1;
                    if (v2 != null) {
                        it = v2;
                        $i$a$-let-TwitchAuthenticationRequestDecorator$SingleRequestExecutor$getFreshToken$2$1 = false;
                        return new IgdbResult.Success<TokenPayloadWithExecutor>(new TokenPayloadWithExecutor(storedTokenPayload, it));
                    }
                    if (this.fetchTokenRequests >= this.maxFetchTokenAttempts) {
                        return new IgdbResult.Failure.ApiFailure(new RequestTokenException("Number of attempts to get a fresh token exceeded the limit of " + this.maxFetchTokenAttempts));
                    }
                    var11_12 = TwitchAuthenticationRequestDecorator.Companion;
                    $continuation.L$0 = this;
                    $continuation.L$1 = var3_6;
                    $continuation.L$2 = storedTokenPayload;
                    $continuation.L$3 = var11_12;
                    $continuation.I$0 = var2_5;
                    $continuation.I$1 = var4_7;
                    $continuation.label = 3;
                    v3 = TwitchAuthenticationRequestDecorator.access$getTwitchTokenFetcher$p(var3_6).invoke(TwitchAuthenticationRequestDecorator.access$getCredentials$p(var3_6), (Continuation<? super IgdbResult<TwitchToken, TwitchErrorResponse>>)$continuation);
                    if (v3 == var14_4) {
                        return var14_4;
                    }
                    ** GOTO lbl84
                }
                case 3: {
                    $i$a$-repeat-TwitchAuthenticationRequestDecorator$SingleRequestExecutor$getFreshToken$2 = false;
                    var4_7 = $continuation.I$1;
                    var2_5 = $continuation.I$0;
                    var11_12 = (Companion)$continuation.L$3;
                    storedTokenPayload = (TwitchTokenPayload)$continuation.L$2;
                    var3_6 = (TwitchAuthenticationRequestDecorator)$continuation.L$1;
                    this = (SingleRequestExecutor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl84:
                    // 2 sources

                    if ((fetchTokenResult = ru.pixnews.igdbclient.internal.twitch.TwitchAuthenticationRequestDecorator$Companion.access$asIgdbResult(var11_12, (IgdbResult)v3)) instanceof IgdbResult.Failure) {
                        return fetchTokenResult;
                    }
                    ++this.fetchTokenRequests;
                    Intrinsics.checkNotNull((Object)fetchTokenResult, (String)"null cannot be cast to non-null type ru.pixnews.igdbclient.IgdbResult.Success<ru.pixnews.igdbclient.auth.twitch.TwitchTokenPayload>");
                    fetchedTokenPayload = (TwitchTokenPayload)((IgdbResult.Success)fetchTokenResult).getValue();
                    $continuation.L$0 = this;
                    $continuation.L$1 = var3_6;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.I$0 = var2_5;
                    $continuation.I$1 = var4_7;
                    $continuation.label = 4;
                    v4 = TwitchAuthenticationRequestDecorator.access$getTokenStorage$p(var3_6).updateToken(storedTokenPayload, fetchedTokenPayload, (Continuation<? super Boolean>)$continuation);
                    if (v4 == var14_4) {
                        return var14_4;
                    }
                    ** GOTO lbl108
                }
                case 4: {
                    $i$a$-repeat-TwitchAuthenticationRequestDecorator$SingleRequestExecutor$getFreshToken$2 = false;
                    var4_7 = $continuation.I$1;
                    var2_5 = $continuation.I$0;
                    var3_6 = (TwitchAuthenticationRequestDecorator)$continuation.L$1;
                    this = (SingleRequestExecutor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl108:
                    // 2 sources

                    ++var4_7;
                    ** GOTO lbl15
                }
            }
            return new IgdbResult.Failure.UnknownFailure(new RequestTokenException("Failed to fetch token"));
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public static final /* synthetic */ Object access$getFreshToken(SingleRequestExecutor $this, Continuation $completion) {
            return $this.getFreshToken((Continuation<IgdbResult<TokenPayloadWithExecutor, IgdbHttpErrorResponse>>)$completion);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u0086\u0002J\t\u0010\f\u001a\u00020\u0005H\u0086\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lru/pixnews/igdbclient/internal/twitch/TwitchAuthenticationRequestDecorator$TokenPayloadWithExecutor;", "", "payload", "Lru/pixnews/igdbclient/auth/twitch/TwitchTokenPayload;", "executor", "Lru/pixnews/igdbclient/internal/RequestExecutor;", "(Lru/pixnews/igdbclient/auth/twitch/TwitchTokenPayload;Lru/pixnews/igdbclient/internal/RequestExecutor;)V", "getExecutor", "()Lru/pixnews/igdbclient/internal/RequestExecutor;", "getPayload", "()Lru/pixnews/igdbclient/auth/twitch/TwitchTokenPayload;", "component1", "component2", "igdbclient-core"})
    private static final class TokenPayloadWithExecutor {
        @NotNull
        private final TwitchTokenPayload payload;
        @NotNull
        private final RequestExecutor executor;

        public TokenPayloadWithExecutor(@NotNull TwitchTokenPayload payload, @NotNull RequestExecutor executor) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            this.payload = payload;
            this.executor = executor;
        }

        @NotNull
        public final TwitchTokenPayload getPayload() {
            return this.payload;
        }

        @NotNull
        public final RequestExecutor getExecutor() {
            return this.executor;
        }

        @NotNull
        public final TwitchTokenPayload component1() {
            return this.payload;
        }

        @NotNull
        public final RequestExecutor component2() {
            return this.executor;
        }
    }
}

