package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Event

/**
 *  Fields of the [Event] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#event](https://api-docs.igdb.com/#event)
 */
public enum class EventField(
  public override val igdbName: String,
) : IgdbField<Event> {
  /**
   *  Field "id" of the [Event] IGDB entity. Matches [Event.id].
   */
  ID("id"),
  /**
   *  Field "name" of the [Event] IGDB entity. Matches [Event.name].
   */
  NAME("name"),
  /**
   *  Field "description" of the [Event] IGDB entity. Matches [Event.description].
   */
  DESCRIPTION("description"),
  /**
   *  Field "slug" of the [Event] IGDB entity. Matches [Event.slug].
   */
  SLUG("slug"),
  /**
   *  Field "event_logo" of the [Event] IGDB entity. Matches [Event.event_logo].
   */
  EVENT_LOGO("event_logo"),
  /**
   *  Field "event_categories" of the [Event] IGDB entity. Matches [Event.event_categories].
   */
  EVENT_CATEGORIES("event_categories"),
  /**
   *  Field "start_time" of the [Event] IGDB entity. Matches [Event.start_time].
   */
  START_TIME("start_time"),
  /**
   *  Field "time_zone" of the [Event] IGDB entity. Matches [Event.time_zone].
   */
  TIME_ZONE("time_zone"),
  /**
   *  Field "end_time" of the [Event] IGDB entity. Matches [Event.end_time].
   */
  END_TIME("end_time"),
  /**
   *  Field "live_stream_url" of the [Event] IGDB entity. Matches [Event.live_stream_url].
   */
  LIVE_STREAM_URL("live_stream_url"),
  /**
   *  Field "games" of the [Event] IGDB entity. Matches [Event.games].
   */
  GAMES("games"),
  /**
   *  Field "videos" of the [Event] IGDB entity. Matches [Event.videos].
   */
  VIDEOS("videos"),
  /**
   *  Field "event_networks" of the [Event] IGDB entity. Matches [Event.event_networks].
   */
  EVENT_NETWORKS("event_networks"),
  /**
   *  Field "created_at" of the [Event] IGDB entity. Matches [Event.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "updated_at" of the [Event] IGDB entity. Matches [Event.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "checksum" of the [Event] IGDB entity. Matches [Event.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
