package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Franchise

/**
 *  Fields of the [Franchise] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#franchise](https://api-docs.igdb.com/#franchise)
 */
public enum class FranchiseField(
  public override val igdbName: String,
) : IgdbField<Franchise> {
  /**
   *  Field "id" of the [Franchise] IGDB entity. Matches [Franchise.id].
   */
  ID("id"),
  /**
   *  Field "created_at" of the [Franchise] IGDB entity. Matches [Franchise.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "games" of the [Franchise] IGDB entity. Matches [Franchise.games].
   */
  GAMES("games"),
  /**
   *  Field "name" of the [Franchise] IGDB entity. Matches [Franchise.name].
   */
  NAME("name"),
  /**
   *  Field "slug" of the [Franchise] IGDB entity. Matches [Franchise.slug].
   */
  SLUG("slug"),
  /**
   *  Field "updated_at" of the [Franchise] IGDB entity. Matches [Franchise.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "url" of the [Franchise] IGDB entity. Matches [Franchise.url].
   */
  URL("url"),
  /**
   *  Field "checksum" of the [Franchise] IGDB entity. Matches [Franchise.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
