package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.GameVersion

/**
 *  Fields of the [GameVersion] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#game-version](https://api-docs.igdb.com/#game-version)
 */
public enum class GameVersionField(
  public override val igdbName: String,
) : IgdbField<GameVersion> {
  /**
   *  Field "id" of the [GameVersion] IGDB entity. Matches [GameVersion.id].
   */
  ID("id"),
  /**
   *  Field "created_at" of the [GameVersion] IGDB entity. Matches [GameVersion.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "features" of the [GameVersion] IGDB entity. Matches [GameVersion.features].
   */
  FEATURES("features"),
  /**
   *  Field "game" of the [GameVersion] IGDB entity. Matches [GameVersion.game].
   */
  GAME("game"),
  /**
   *  Field "games" of the [GameVersion] IGDB entity. Matches [GameVersion.games].
   */
  GAMES("games"),
  /**
   *  Field "updated_at" of the [GameVersion] IGDB entity. Matches [GameVersion.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "url" of the [GameVersion] IGDB entity. Matches [GameVersion.url].
   */
  URL("url"),
  /**
   *  Field "checksum" of the [GameVersion] IGDB entity. Matches [GameVersion.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
