package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.CollectionMembership
import ru.pixnews.igdbclient.scheme.`field`.CollectionMembershipField

private val _collectionMembershipFieldDslInstance: CollectionMembershipFieldDsl =
    CollectionMembershipFieldDsl()

public val CollectionMembership.Companion.`field`: CollectionMembershipFieldDsl
  get() = _collectionMembershipFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [CollectionMembership] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#collection-membership](https://api-docs.igdb.com/#collection-membership)
 */
@IgdbClientDsl
public class CollectionMembershipFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<CollectionMembershipField, CollectionMembership>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [CollectionMembership] Igdb entity.
   *
   *  The value will be returned in the [CollectionMembership.id] field of the response
   */
  public val id: IgdbRequestField<CollectionMembership>
    get() = fieldWithId(CollectionMembershipField.ID)

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(CollectionMembershipField.GAME))

  /**
   *  Fields of the "collection" ([Collection][ru.pixnews.igdbclient.model.Collection]) nested IGDB
   * entity
   */
  public val collection: CollectionFieldDsl
    get() = CollectionFieldDsl(fieldWithId(CollectionMembershipField.COLLECTION))

  /**
   *  Fields of the "type"
   * ([CollectionMembershipType][ru.pixnews.igdbclient.model.CollectionMembershipType]) nested IGDB
   * entity
   */
  public val type: CollectionMembershipTypeFieldDsl
    get() = CollectionMembershipTypeFieldDsl(fieldWithId(CollectionMembershipField.TYPE))

  /**
   *  Query for the "updated_at" field of the [CollectionMembership] Igdb entity.
   *
   *  The value will be returned in the [CollectionMembership.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<CollectionMembership>
    get() = fieldWithId(CollectionMembershipField.UPDATED_AT)

  /**
   *  Query for the "created_at" field of the [CollectionMembership] Igdb entity.
   *
   *  The value will be returned in the [CollectionMembership.created_at] field of the response
   */
  public val created_at: IgdbRequestField<CollectionMembership>
    get() = fieldWithId(CollectionMembershipField.CREATED_AT)

  /**
   *  Query for the "checksum" field of the [CollectionMembership] Igdb entity.
   *
   *  The value will be returned in the [CollectionMembership.checksum] field of the response
   */
  public val checksum: IgdbRequestField<CollectionMembership>
    get() = fieldWithId(CollectionMembershipField.CHECKSUM)
}
