package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.CollectionMembershipType
import ru.pixnews.igdbclient.scheme.`field`.CollectionMembershipTypeField

private val _collectionMembershipTypeFieldDslInstance: CollectionMembershipTypeFieldDsl =
    CollectionMembershipTypeFieldDsl()

public val CollectionMembershipType.Companion.`field`: CollectionMembershipTypeFieldDsl
  get() = _collectionMembershipTypeFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [CollectionMembershipType] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#collection-membership-type](https://api-docs.igdb.com/#collection-membership-type)
 */
@IgdbClientDsl
public class CollectionMembershipTypeFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<CollectionMembershipTypeField, CollectionMembershipType>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [CollectionMembershipType] Igdb entity.
   *
   *  The value will be returned in the [CollectionMembershipType.id] field of the response
   */
  public val id: IgdbRequestField<CollectionMembershipType>
    get() = fieldWithId(CollectionMembershipTypeField.ID)

  /**
   *  Query for the "name" field of the [CollectionMembershipType] Igdb entity.
   *
   *  The value will be returned in the [CollectionMembershipType.name] field of the response
   */
  public val name: IgdbRequestField<CollectionMembershipType>
    get() = fieldWithId(CollectionMembershipTypeField.NAME)

  /**
   *  Query for the "description" field of the [CollectionMembershipType] Igdb entity.
   *
   *  The value will be returned in the [CollectionMembershipType.description] field of the response
   */
  public val description: IgdbRequestField<CollectionMembershipType>
    get() = fieldWithId(CollectionMembershipTypeField.DESCRIPTION)

  /**
   *  Fields of the "allowed_collection_type"
   * ([CollectionType][ru.pixnews.igdbclient.model.CollectionType]) nested IGDB entity
   */
  public val allowed_collection_type: CollectionTypeFieldDsl
    get() =
        CollectionTypeFieldDsl(fieldWithId(CollectionMembershipTypeField.ALLOWED_COLLECTION_TYPE))

  /**
   *  Query for the "updated_at" field of the [CollectionMembershipType] Igdb entity.
   *
   *  The value will be returned in the [CollectionMembershipType.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<CollectionMembershipType>
    get() = fieldWithId(CollectionMembershipTypeField.UPDATED_AT)

  /**
   *  Query for the "created_at" field of the [CollectionMembershipType] Igdb entity.
   *
   *  The value will be returned in the [CollectionMembershipType.created_at] field of the response
   */
  public val created_at: IgdbRequestField<CollectionMembershipType>
    get() = fieldWithId(CollectionMembershipTypeField.CREATED_AT)

  /**
   *  Query for the "checksum" field of the [CollectionMembershipType] Igdb entity.
   *
   *  The value will be returned in the [CollectionMembershipType.checksum] field of the response
   */
  public val checksum: IgdbRequestField<CollectionMembershipType>
    get() = fieldWithId(CollectionMembershipTypeField.CHECKSUM)
}
