package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.ReleaseDate
import ru.pixnews.igdbclient.scheme.`field`.ReleaseDateField

private val _releaseDateFieldDslInstance: ReleaseDateFieldDsl = ReleaseDateFieldDsl()

public val ReleaseDate.Companion.`field`: ReleaseDateFieldDsl
  get() = _releaseDateFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [ReleaseDate] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#release-date](https://api-docs.igdb.com/#release-date)
 */
@IgdbClientDsl
public class ReleaseDateFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<ReleaseDateField, ReleaseDate>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [ReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDate.id] field of the response
   */
  public val id: IgdbRequestField<ReleaseDate>
    get() = fieldWithId(ReleaseDateField.ID)

  /**
   *  Query for the "category" field of the [ReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDate.category] field of the response
   */
  public val category: IgdbRequestField<ReleaseDate>
    get() = fieldWithId(ReleaseDateField.CATEGORY)

  /**
   *  Query for the "created_at" field of the [ReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDate.created_at] field of the response
   */
  public val created_at: IgdbRequestField<ReleaseDate>
    get() = fieldWithId(ReleaseDateField.CREATED_AT)

  /**
   *  Query for the "date" field of the [ReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDate.date] field of the response
   */
  public val date: IgdbRequestField<ReleaseDate>
    get() = fieldWithId(ReleaseDateField.DATE)

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(ReleaseDateField.GAME))

  /**
   *  Query for the "human" field of the [ReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDate.human] field of the response
   */
  public val human: IgdbRequestField<ReleaseDate>
    get() = fieldWithId(ReleaseDateField.HUMAN)

  /**
   *  Query for the "m" field of the [ReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDate.m] field of the response
   */
  public val m: IgdbRequestField<ReleaseDate>
    get() = fieldWithId(ReleaseDateField.M)

  /**
   *  Fields of the "platform" ([Platform][ru.pixnews.igdbclient.model.Platform]) nested IGDB entity
   */
  public val platform: PlatformFieldDsl
    get() = PlatformFieldDsl(fieldWithId(ReleaseDateField.PLATFORM))

  /**
   *  Query for the "region" field of the [ReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDate.region] field of the response
   */
  public val region: IgdbRequestField<ReleaseDate>
    get() = fieldWithId(ReleaseDateField.REGION)

  /**
   *  Query for the "updated_at" field of the [ReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDate.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<ReleaseDate>
    get() = fieldWithId(ReleaseDateField.UPDATED_AT)

  /**
   *  Query for the "y" field of the [ReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDate.y] field of the response
   */
  public val y: IgdbRequestField<ReleaseDate>
    get() = fieldWithId(ReleaseDateField.Y)

  /**
   *  Query for the "checksum" field of the [ReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [ReleaseDate.checksum] field of the response
   */
  public val checksum: IgdbRequestField<ReleaseDate>
    get() = fieldWithId(ReleaseDateField.CHECKSUM)

  /**
   *  Fields of the "status" ([ReleaseDateStatus][ru.pixnews.igdbclient.model.ReleaseDateStatus])
   * nested IGDB entity
   */
  public val status: ReleaseDateStatusFieldDsl
    get() = ReleaseDateStatusFieldDsl(fieldWithId(ReleaseDateField.STATUS))
}
