package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Keyword

/**
 *  Fields of the [Keyword] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#keyword](https://api-docs.igdb.com/#keyword)
 */
public enum class KeywordField(
  public override val igdbName: String,
) : IgdbField<Keyword> {
  /**
   *  Field "id" of the [Keyword] IGDB entity. Matches [Keyword.id].
   */
  ID("id"),
  /**
   *  Field "created_at" of the [Keyword] IGDB entity. Matches [Keyword.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "name" of the [Keyword] IGDB entity. Matches [Keyword.name].
   */
  NAME("name"),
  /**
   *  Field "slug" of the [Keyword] IGDB entity. Matches [Keyword.slug].
   */
  SLUG("slug"),
  /**
   *  Field "updated_at" of the [Keyword] IGDB entity. Matches [Keyword.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "url" of the [Keyword] IGDB entity. Matches [Keyword.url].
   */
  URL("url"),
  /**
   *  Field "checksum" of the [Keyword] IGDB entity. Matches [Keyword.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
