package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.GameVersionFeature
import ru.pixnews.igdbclient.scheme.`field`.GameVersionFeatureField

private val _gameVersionFeatureFieldDslInstance: GameVersionFeatureFieldDsl =
    GameVersionFeatureFieldDsl()

public val GameVersionFeature.Companion.`field`: GameVersionFeatureFieldDsl
  get() = _gameVersionFeatureFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [GameVersionFeature] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#game-version-feature](https://api-docs.igdb.com/#game-version-feature)
 */
@IgdbClientDsl
public class GameVersionFeatureFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<GameVersionFeatureField, GameVersionFeature>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [GameVersionFeature] Igdb entity.
   *
   *  The value will be returned in the [GameVersionFeature.id] field of the response
   */
  public val id: IgdbRequestField<GameVersionFeature>
    get() = fieldWithId(GameVersionFeatureField.ID)

  /**
   *  Query for the "category" field of the [GameVersionFeature] Igdb entity.
   *
   *  The value will be returned in the [GameVersionFeature.category] field of the response
   */
  public val category: IgdbRequestField<GameVersionFeature>
    get() = fieldWithId(GameVersionFeatureField.CATEGORY)

  /**
   *  Query for the "description" field of the [GameVersionFeature] Igdb entity.
   *
   *  The value will be returned in the [GameVersionFeature.description] field of the response
   */
  public val description: IgdbRequestField<GameVersionFeature>
    get() = fieldWithId(GameVersionFeatureField.DESCRIPTION)

  /**
   *  Query for the "position" field of the [GameVersionFeature] Igdb entity.
   *
   *  The value will be returned in the [GameVersionFeature.position] field of the response
   */
  public val position: IgdbRequestField<GameVersionFeature>
    get() = fieldWithId(GameVersionFeatureField.POSITION)

  /**
   *  Query for the "title" field of the [GameVersionFeature] Igdb entity.
   *
   *  The value will be returned in the [GameVersionFeature.title] field of the response
   */
  public val title: IgdbRequestField<GameVersionFeature>
    get() = fieldWithId(GameVersionFeatureField.TITLE)

  /**
   *  Fields of the "values"
   * ([GameVersionFeatureValue][ru.pixnews.igdbclient.model.GameVersionFeatureValue]) nested IGDB
   * entity
   */
  public val values: GameVersionFeatureValueFieldDsl
    get() = GameVersionFeatureValueFieldDsl(fieldWithId(GameVersionFeatureField.VALUES))

  /**
   *  Query for the "checksum" field of the [GameVersionFeature] Igdb entity.
   *
   *  The value will be returned in the [GameVersionFeature.checksum] field of the response
   */
  public val checksum: IgdbRequestField<GameVersionFeature>
    get() = fieldWithId(GameVersionFeatureField.CHECKSUM)
}
