package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.NetworkType
import ru.pixnews.igdbclient.scheme.`field`.NetworkTypeField

private val _networkTypeFieldDslInstance: NetworkTypeFieldDsl = NetworkTypeFieldDsl()

public val NetworkType.Companion.`field`: NetworkTypeFieldDsl
  get() = _networkTypeFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [NetworkType] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#network-type](https://api-docs.igdb.com/#network-type)
 */
@IgdbClientDsl
public class NetworkTypeFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<NetworkTypeField, NetworkType>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [NetworkType] Igdb entity.
   *
   *  The value will be returned in the [NetworkType.id] field of the response
   */
  public val id: IgdbRequestField<NetworkType>
    get() = fieldWithId(NetworkTypeField.ID)

  /**
   *  Query for the "name" field of the [NetworkType] Igdb entity.
   *
   *  The value will be returned in the [NetworkType.name] field of the response
   */
  public val name: IgdbRequestField<NetworkType>
    get() = fieldWithId(NetworkTypeField.NAME)

  /**
   *  Fields of the "event_networks" ([EventNetwork][ru.pixnews.igdbclient.model.EventNetwork])
   * nested IGDB entity
   */
  public val event_networks: EventNetworkFieldDsl
    get() = EventNetworkFieldDsl(fieldWithId(NetworkTypeField.EVENT_NETWORKS))

  /**
   *  Query for the "created_at" field of the [NetworkType] Igdb entity.
   *
   *  The value will be returned in the [NetworkType.created_at] field of the response
   */
  public val created_at: IgdbRequestField<NetworkType>
    get() = fieldWithId(NetworkTypeField.CREATED_AT)

  /**
   *  Query for the "updated_at" field of the [NetworkType] Igdb entity.
   *
   *  The value will be returned in the [NetworkType.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<NetworkType>
    get() = fieldWithId(NetworkTypeField.UPDATED_AT)

  /**
   *  Query for the "checksum" field of the [NetworkType] Igdb entity.
   *
   *  The value will be returned in the [NetworkType.checksum] field of the response
   */
  public val checksum: IgdbRequestField<NetworkType>
    get() = fieldWithId(NetworkTypeField.CHECKSUM)
}
