package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.PlatformVersionCompany

/**
 *  Fields of the [PlatformVersionCompany] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#platform-version-company](https://api-docs.igdb.com/#platform-version-company)
 */
public enum class PlatformVersionCompanyField(
  public override val igdbName: String,
) : IgdbField<PlatformVersionCompany> {
  /**
   *  Field "id" of the [PlatformVersionCompany] IGDB entity. Matches [PlatformVersionCompany.id].
   */
  ID("id"),
  /**
   *  Field "comment" of the [PlatformVersionCompany] IGDB entity. Matches
   * [PlatformVersionCompany.comment].
   */
  COMMENT("comment"),
  /**
   *  Field "company" of the [PlatformVersionCompany] IGDB entity. Matches
   * [PlatformVersionCompany.company].
   */
  COMPANY("company"),
  /**
   *  Field "developer" of the [PlatformVersionCompany] IGDB entity. Matches
   * [PlatformVersionCompany.developer].
   */
  DEVELOPER("developer"),
  /**
   *  Field "manufacturer" of the [PlatformVersionCompany] IGDB entity. Matches
   * [PlatformVersionCompany.manufacturer].
   */
  MANUFACTURER("manufacturer"),
  /**
   *  Field "checksum" of the [PlatformVersionCompany] IGDB entity. Matches
   * [PlatformVersionCompany.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
