package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.PopularityPrimitive

/**
 *  Fields of the [PopularityPrimitive] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#popularity-primitive](https://api-docs.igdb.com/#popularity-primitive)
 */
public enum class PopularityPrimitiveField(
  public override val igdbName: String,
) : IgdbField<PopularityPrimitive> {
  /**
   *  Field "id" of the [PopularityPrimitive] IGDB entity. Matches [PopularityPrimitive.id].
   */
  ID("id"),
  /**
   *  Field "game_id" of the [PopularityPrimitive] IGDB entity. Matches
   * [PopularityPrimitive.game_id].
   */
  GAME_ID("game_id"),
  /**
   *  Field "popularity_type" of the [PopularityPrimitive] IGDB entity. Matches
   * [PopularityPrimitive.popularity_type].
   */
  POPULARITY_TYPE("popularity_type"),
  /**
   *  Field "popularity_source" of the [PopularityPrimitive] IGDB entity. Matches
   * [PopularityPrimitive.popularity_source].
   */
  POPULARITY_SOURCE("popularity_source"),
  /**
   *  Field "value" of the [PopularityPrimitive] IGDB entity. Matches [PopularityPrimitive.`value`].
   */
  VALUE("value"),
  /**
   *  Field "calculated_at" of the [PopularityPrimitive] IGDB entity. Matches
   * [PopularityPrimitive.calculated_at].
   */
  CALCULATED_AT("calculated_at"),
  /**
   *  Field "created_at" of the [PopularityPrimitive] IGDB entity. Matches
   * [PopularityPrimitive.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "updated_at" of the [PopularityPrimitive] IGDB entity. Matches
   * [PopularityPrimitive.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "checksum" of the [PopularityPrimitive] IGDB entity. Matches
   * [PopularityPrimitive.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
