package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.PlatformVersion
import ru.pixnews.igdbclient.scheme.`field`.PlatformVersionField

private val _platformVersionFieldDslInstance: PlatformVersionFieldDsl = PlatformVersionFieldDsl()

public val PlatformVersion.Companion.`field`: PlatformVersionFieldDsl
  get() = _platformVersionFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [PlatformVersion] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#platform-version](https://api-docs.igdb.com/#platform-version)
 */
@IgdbClientDsl
public class PlatformVersionFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<PlatformVersionField, PlatformVersion>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.id] field of the response
   */
  public val id: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.ID)

  /**
   *  Fields of the "companies"
   * ([PlatformVersionCompany][ru.pixnews.igdbclient.model.PlatformVersionCompany]) nested IGDB entity
   */
  public val companies: PlatformVersionCompanyFieldDsl
    get() = PlatformVersionCompanyFieldDsl(fieldWithId(PlatformVersionField.COMPANIES))

  /**
   *  Query for the "connectivity" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.connectivity] field of the response
   */
  public val connectivity: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.CONNECTIVITY)

  /**
   *  Query for the "cpu" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.cpu] field of the response
   */
  public val cpu: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.CPU)

  /**
   *  Query for the "graphics" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.graphics] field of the response
   */
  public val graphics: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.GRAPHICS)

  /**
   *  Fields of the "main_manufacturer"
   * ([PlatformVersionCompany][ru.pixnews.igdbclient.model.PlatformVersionCompany]) nested IGDB entity
   */
  public val main_manufacturer: PlatformVersionCompanyFieldDsl
    get() = PlatformVersionCompanyFieldDsl(fieldWithId(PlatformVersionField.MAIN_MANUFACTURER))

  /**
   *  Query for the "media" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.media] field of the response
   */
  public val media: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.MEDIA)

  /**
   *  Query for the "memory" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.memory] field of the response
   */
  public val memory: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.MEMORY)

  /**
   *  Query for the "name" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.name] field of the response
   */
  public val name: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.NAME)

  /**
   *  Query for the "online" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.online] field of the response
   */
  public val online: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.ONLINE)

  /**
   *  Query for the "os" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.os] field of the response
   */
  public val os: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.OS)

  /**
   *  Query for the "output" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.output] field of the response
   */
  public val output: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.OUTPUT)

  /**
   *  Fields of the "platform_logo" ([PlatformLogo][ru.pixnews.igdbclient.model.PlatformLogo])
   * nested IGDB entity
   */
  public val platform_logo: PlatformLogoFieldDsl
    get() = PlatformLogoFieldDsl(fieldWithId(PlatformVersionField.PLATFORM_LOGO))

  /**
   *  Fields of the "platform_version_release_dates"
   * ([PlatformVersionReleaseDate][ru.pixnews.igdbclient.model.PlatformVersionReleaseDate]) nested IGDB
   * entity
   */
  public val platform_version_release_dates: PlatformVersionReleaseDateFieldDsl
    get() =
        PlatformVersionReleaseDateFieldDsl(fieldWithId(PlatformVersionField.PLATFORM_VERSION_RELEASE_DATES))

  /**
   *  Query for the "resolutions" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.resolutions] field of the response
   */
  public val resolutions: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.RESOLUTIONS)

  /**
   *  Query for the "slug" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.slug] field of the response
   */
  public val slug: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.SLUG)

  /**
   *  Query for the "sound" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.sound] field of the response
   */
  public val sound: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.SOUND)

  /**
   *  Query for the "storage" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.storage] field of the response
   */
  public val storage: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.STORAGE)

  /**
   *  Query for the "summary" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.summary] field of the response
   */
  public val summary: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.SUMMARY)

  /**
   *  Query for the "url" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.url] field of the response
   */
  public val url: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.URL)

  /**
   *  Query for the "checksum" field of the [PlatformVersion] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersion.checksum] field of the response
   */
  public val checksum: IgdbRequestField<PlatformVersion>
    get() = fieldWithId(PlatformVersionField.CHECKSUM)
}
