package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Cover

/**
 *  Fields of the [Cover] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#cover](https://api-docs.igdb.com/#cover)
 */
public enum class CoverField(
  public override val igdbName: String,
) : IgdbField<Cover> {
  /**
   *  Field "id" of the [Cover] IGDB entity. Matches [Cover.id].
   */
  ID("id"),
  /**
   *  Field "alpha_channel" of the [Cover] IGDB entity. Matches [Cover.alpha_channel].
   */
  ALPHA_CHANNEL("alpha_channel"),
  /**
   *  Field "animated" of the [Cover] IGDB entity. Matches [Cover.animated].
   */
  ANIMATED("animated"),
  /**
   *  Field "game" of the [Cover] IGDB entity. Matches [Cover.game].
   */
  GAME("game"),
  /**
   *  Field "height" of the [Cover] IGDB entity. Matches [Cover.height].
   */
  HEIGHT("height"),
  /**
   *  Field "image_id" of the [Cover] IGDB entity. Matches [Cover.image_id].
   */
  IMAGE_ID("image_id"),
  /**
   *  Field "url" of the [Cover] IGDB entity. Matches [Cover.url].
   */
  URL("url"),
  /**
   *  Field "width" of the [Cover] IGDB entity. Matches [Cover.width].
   */
  WIDTH("width"),
  /**
   *  Field "checksum" of the [Cover] IGDB entity. Matches [Cover.checksum].
   */
  CHECKSUM("checksum"),
  /**
   *  Field "game_localization" of the [Cover] IGDB entity. Matches [Cover.game_localization].
   */
  GAME_LOCALIZATION("game_localization"),
  ;

  override fun toString(): String = igdbName
}
