package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.PlayerPerspective

/**
 *  Fields of the [PlayerPerspective] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#player-perspective](https://api-docs.igdb.com/#player-perspective)
 */
public enum class PlayerPerspectiveField(
  public override val igdbName: String,
) : IgdbField<PlayerPerspective> {
  /**
   *  Field "id" of the [PlayerPerspective] IGDB entity. Matches [PlayerPerspective.id].
   */
  ID("id"),
  /**
   *  Field "created_at" of the [PlayerPerspective] IGDB entity. Matches
   * [PlayerPerspective.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "name" of the [PlayerPerspective] IGDB entity. Matches [PlayerPerspective.name].
   */
  NAME("name"),
  /**
   *  Field "slug" of the [PlayerPerspective] IGDB entity. Matches [PlayerPerspective.slug].
   */
  SLUG("slug"),
  /**
   *  Field "updated_at" of the [PlayerPerspective] IGDB entity. Matches
   * [PlayerPerspective.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "url" of the [PlayerPerspective] IGDB entity. Matches [PlayerPerspective.url].
   */
  URL("url"),
  /**
   *  Field "checksum" of the [PlayerPerspective] IGDB entity. Matches [PlayerPerspective.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
