package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.AgeRating
import ru.pixnews.igdbclient.scheme.`field`.AgeRatingField

private val _ageRatingFieldDslInstance: AgeRatingFieldDsl = AgeRatingFieldDsl()

public val AgeRating.Companion.`field`: AgeRatingFieldDsl
  get() = _ageRatingFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [AgeRating] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#age-rating](https://api-docs.igdb.com/#age-rating)
 */
@IgdbClientDsl
public class AgeRatingFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<AgeRatingField, AgeRating>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [AgeRating] Igdb entity.
   *
   *  The value will be returned in the [AgeRating.id] field of the response
   */
  public val id: IgdbRequestField<AgeRating>
    get() = fieldWithId(AgeRatingField.ID)

  /**
   *  Query for the "category" field of the [AgeRating] Igdb entity.
   *
   *  The value will be returned in the [AgeRating.category] field of the response
   */
  public val category: IgdbRequestField<AgeRating>
    get() = fieldWithId(AgeRatingField.CATEGORY)

  /**
   *  Fields of the "content_descriptions"
   * ([AgeRatingContentDescription][ru.pixnews.igdbclient.model.AgeRatingContentDescription]) nested
   * IGDB entity
   */
  public val content_descriptions: AgeRatingContentDescriptionFieldDsl
    get() = AgeRatingContentDescriptionFieldDsl(fieldWithId(AgeRatingField.CONTENT_DESCRIPTIONS))

  /**
   *  Query for the "rating" field of the [AgeRating] Igdb entity.
   *
   *  The value will be returned in the [AgeRating.rating] field of the response
   */
  public val rating: IgdbRequestField<AgeRating>
    get() = fieldWithId(AgeRatingField.RATING)

  /**
   *  Query for the "rating_cover_url" field of the [AgeRating] Igdb entity.
   *
   *  The value will be returned in the [AgeRating.rating_cover_url] field of the response
   */
  public val rating_cover_url: IgdbRequestField<AgeRating>
    get() = fieldWithId(AgeRatingField.RATING_COVER_URL)

  /**
   *  Query for the "synopsis" field of the [AgeRating] Igdb entity.
   *
   *  The value will be returned in the [AgeRating.synopsis] field of the response
   */
  public val synopsis: IgdbRequestField<AgeRating>
    get() = fieldWithId(AgeRatingField.SYNOPSIS)

  /**
   *  Query for the "checksum" field of the [AgeRating] Igdb entity.
   *
   *  The value will be returned in the [AgeRating.checksum] field of the response
   */
  public val checksum: IgdbRequestField<AgeRating>
    get() = fieldWithId(AgeRatingField.CHECKSUM)
}
