package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Collection
import ru.pixnews.igdbclient.scheme.`field`.CollectionField

private val _collectionFieldDslInstance: CollectionFieldDsl = CollectionFieldDsl()

public val Collection.Companion.`field`: CollectionFieldDsl
  get() = _collectionFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Collection] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#collection](https://api-docs.igdb.com/#collection)
 */
@IgdbClientDsl
public class CollectionFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<CollectionField, Collection>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Collection] Igdb entity.
   *
   *  The value will be returned in the [Collection.id] field of the response
   */
  public val id: IgdbRequestField<Collection>
    get() = fieldWithId(CollectionField.ID)

  /**
   *  Query for the "created_at" field of the [Collection] Igdb entity.
   *
   *  The value will be returned in the [Collection.created_at] field of the response
   */
  public val created_at: IgdbRequestField<Collection>
    get() = fieldWithId(CollectionField.CREATED_AT)

  /**
   *  Fields of the "games" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val games: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(CollectionField.GAMES))

  /**
   *  Query for the "name" field of the [Collection] Igdb entity.
   *
   *  The value will be returned in the [Collection.name] field of the response
   */
  public val name: IgdbRequestField<Collection>
    get() = fieldWithId(CollectionField.NAME)

  /**
   *  Query for the "slug" field of the [Collection] Igdb entity.
   *
   *  The value will be returned in the [Collection.slug] field of the response
   */
  public val slug: IgdbRequestField<Collection>
    get() = fieldWithId(CollectionField.SLUG)

  /**
   *  Query for the "updated_at" field of the [Collection] Igdb entity.
   *
   *  The value will be returned in the [Collection.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<Collection>
    get() = fieldWithId(CollectionField.UPDATED_AT)

  /**
   *  Query for the "url" field of the [Collection] Igdb entity.
   *
   *  The value will be returned in the [Collection.url] field of the response
   */
  public val url: IgdbRequestField<Collection>
    get() = fieldWithId(CollectionField.URL)

  /**
   *  Query for the "checksum" field of the [Collection] Igdb entity.
   *
   *  The value will be returned in the [Collection.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Collection>
    get() = fieldWithId(CollectionField.CHECKSUM)

  /**
   *  Fields of the "type" ([CollectionType][ru.pixnews.igdbclient.model.CollectionType]) nested
   * IGDB entity
   */
  public val type: CollectionTypeFieldDsl
    get() = CollectionTypeFieldDsl(fieldWithId(CollectionField.TYPE))

  /**
   *  Fields of the "as_parent_relations"
   * ([CollectionRelation][ru.pixnews.igdbclient.model.CollectionRelation]) nested IGDB entity
   */
  public val as_parent_relations: CollectionRelationFieldDsl
    get() = CollectionRelationFieldDsl(fieldWithId(CollectionField.AS_PARENT_RELATIONS))

  /**
   *  Fields of the "as_child_relations"
   * ([CollectionRelation][ru.pixnews.igdbclient.model.CollectionRelation]) nested IGDB entity
   */
  public val as_child_relations: CollectionRelationFieldDsl
    get() = CollectionRelationFieldDsl(fieldWithId(CollectionField.AS_CHILD_RELATIONS))
}
