package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.ExternalGame
import ru.pixnews.igdbclient.scheme.`field`.ExternalGameField

private val _externalGameFieldDslInstance: ExternalGameFieldDsl = ExternalGameFieldDsl()

public val ExternalGame.Companion.`field`: ExternalGameFieldDsl
  get() = _externalGameFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [ExternalGame] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#external-game](https://api-docs.igdb.com/#external-game)
 */
@IgdbClientDsl
public class ExternalGameFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<ExternalGameField, ExternalGame>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [ExternalGame] Igdb entity.
   *
   *  The value will be returned in the [ExternalGame.id] field of the response
   */
  public val id: IgdbRequestField<ExternalGame>
    get() = fieldWithId(ExternalGameField.ID)

  /**
   *  Query for the "category" field of the [ExternalGame] Igdb entity.
   *
   *  The value will be returned in the [ExternalGame.category] field of the response
   */
  public val category: IgdbRequestField<ExternalGame>
    get() = fieldWithId(ExternalGameField.CATEGORY)

  /**
   *  Query for the "created_at" field of the [ExternalGame] Igdb entity.
   *
   *  The value will be returned in the [ExternalGame.created_at] field of the response
   */
  public val created_at: IgdbRequestField<ExternalGame>
    get() = fieldWithId(ExternalGameField.CREATED_AT)

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(ExternalGameField.GAME))

  /**
   *  Query for the "name" field of the [ExternalGame] Igdb entity.
   *
   *  The value will be returned in the [ExternalGame.name] field of the response
   */
  public val name: IgdbRequestField<ExternalGame>
    get() = fieldWithId(ExternalGameField.NAME)

  /**
   *  Query for the "uid" field of the [ExternalGame] Igdb entity.
   *
   *  The value will be returned in the [ExternalGame.uid] field of the response
   */
  public val uid: IgdbRequestField<ExternalGame>
    get() = fieldWithId(ExternalGameField.UID)

  /**
   *  Query for the "updated_at" field of the [ExternalGame] Igdb entity.
   *
   *  The value will be returned in the [ExternalGame.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<ExternalGame>
    get() = fieldWithId(ExternalGameField.UPDATED_AT)

  /**
   *  Query for the "url" field of the [ExternalGame] Igdb entity.
   *
   *  The value will be returned in the [ExternalGame.url] field of the response
   */
  public val url: IgdbRequestField<ExternalGame>
    get() = fieldWithId(ExternalGameField.URL)

  /**
   *  Query for the "year" field of the [ExternalGame] Igdb entity.
   *
   *  The value will be returned in the [ExternalGame.year] field of the response
   */
  public val year: IgdbRequestField<ExternalGame>
    get() = fieldWithId(ExternalGameField.YEAR)

  /**
   *  Query for the "media" field of the [ExternalGame] Igdb entity.
   *
   *  The value will be returned in the [ExternalGame.media] field of the response
   */
  public val media: IgdbRequestField<ExternalGame>
    get() = fieldWithId(ExternalGameField.MEDIA)

  /**
   *  Fields of the "platform" ([Platform][ru.pixnews.igdbclient.model.Platform]) nested IGDB entity
   */
  public val platform: PlatformFieldDsl
    get() = PlatformFieldDsl(fieldWithId(ExternalGameField.PLATFORM))

  /**
   *  Query for the "countries" field of the [ExternalGame] Igdb entity.
   *
   *  The value will be returned in the [ExternalGame.countries] field of the response
   */
  public val countries: IgdbRequestField<ExternalGame>
    get() = fieldWithId(ExternalGameField.COUNTRIES)

  /**
   *  Query for the "checksum" field of the [ExternalGame] Igdb entity.
   *
   *  The value will be returned in the [ExternalGame.checksum] field of the response
   */
  public val checksum: IgdbRequestField<ExternalGame>
    get() = fieldWithId(ExternalGameField.CHECKSUM)
}
