package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.EventLogo
import ru.pixnews.igdbclient.scheme.`field`.EventLogoField

private val _eventLogoFieldDslInstance: EventLogoFieldDsl = EventLogoFieldDsl()

public val EventLogo.Companion.`field`: EventLogoFieldDsl
  get() = _eventLogoFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [EventLogo] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#event-logo](https://api-docs.igdb.com/#event-logo)
 */
@IgdbClientDsl
public class EventLogoFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<EventLogoField, EventLogo>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [EventLogo] Igdb entity.
   *
   *  The value will be returned in the [EventLogo.id] field of the response
   */
  public val id: IgdbRequestField<EventLogo>
    get() = fieldWithId(EventLogoField.ID)

  /**
   *  Fields of the "event" ([Event][ru.pixnews.igdbclient.model.Event]) nested IGDB entity
   */
  public val event: EventFieldDsl
    get() = EventFieldDsl(fieldWithId(EventLogoField.EVENT))

  /**
   *  Query for the "alpha_channel" field of the [EventLogo] Igdb entity.
   *
   *  The value will be returned in the [EventLogo.alpha_channel] field of the response
   */
  public val alpha_channel: IgdbRequestField<EventLogo>
    get() = fieldWithId(EventLogoField.ALPHA_CHANNEL)

  /**
   *  Query for the "animated" field of the [EventLogo] Igdb entity.
   *
   *  The value will be returned in the [EventLogo.animated] field of the response
   */
  public val animated: IgdbRequestField<EventLogo>
    get() = fieldWithId(EventLogoField.ANIMATED)

  /**
   *  Query for the "height" field of the [EventLogo] Igdb entity.
   *
   *  The value will be returned in the [EventLogo.height] field of the response
   */
  public val height: IgdbRequestField<EventLogo>
    get() = fieldWithId(EventLogoField.HEIGHT)

  /**
   *  Query for the "image_id" field of the [EventLogo] Igdb entity.
   *
   *  The value will be returned in the [EventLogo.image_id] field of the response
   */
  public val image_id: IgdbRequestField<EventLogo>
    get() = fieldWithId(EventLogoField.IMAGE_ID)

  /**
   *  Query for the "url" field of the [EventLogo] Igdb entity.
   *
   *  The value will be returned in the [EventLogo.url] field of the response
   */
  public val url: IgdbRequestField<EventLogo>
    get() = fieldWithId(EventLogoField.URL)

  /**
   *  Query for the "width" field of the [EventLogo] Igdb entity.
   *
   *  The value will be returned in the [EventLogo.width] field of the response
   */
  public val width: IgdbRequestField<EventLogo>
    get() = fieldWithId(EventLogoField.WIDTH)

  /**
   *  Query for the "created_at" field of the [EventLogo] Igdb entity.
   *
   *  The value will be returned in the [EventLogo.created_at] field of the response
   */
  public val created_at: IgdbRequestField<EventLogo>
    get() = fieldWithId(EventLogoField.CREATED_AT)

  /**
   *  Query for the "updated_at" field of the [EventLogo] Igdb entity.
   *
   *  The value will be returned in the [EventLogo.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<EventLogo>
    get() = fieldWithId(EventLogoField.UPDATED_AT)

  /**
   *  Query for the "checksum" field of the [EventLogo] Igdb entity.
   *
   *  The value will be returned in the [EventLogo.checksum] field of the response
   */
  public val checksum: IgdbRequestField<EventLogo>
    get() = fieldWithId(EventLogoField.CHECKSUM)
}
