package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Game
import ru.pixnews.igdbclient.scheme.`field`.GameField

private val _gameFieldDslInstance: GameFieldDsl = GameFieldDsl()

public val Game.Companion.`field`: GameFieldDsl
  get() = _gameFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Game] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#game](https://api-docs.igdb.com/#game)
 */
@IgdbClientDsl
public class GameFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<GameField, Game>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.id] field of the response
   */
  public val id: IgdbRequestField<Game>
    get() = fieldWithId(GameField.ID)

  /**
   *  Fields of the "age_ratings" ([AgeRating][ru.pixnews.igdbclient.model.AgeRating]) nested IGDB
   * entity
   */
  public val age_ratings: AgeRatingFieldDsl
    get() = AgeRatingFieldDsl(fieldWithId(GameField.AGE_RATINGS))

  /**
   *  Query for the "aggregated_rating" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.aggregated_rating] field of the response
   */
  public val aggregated_rating: IgdbRequestField<Game>
    get() = fieldWithId(GameField.AGGREGATED_RATING)

  /**
   *  Query for the "aggregated_rating_count" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.aggregated_rating_count] field of the response
   */
  public val aggregated_rating_count: IgdbRequestField<Game>
    get() = fieldWithId(GameField.AGGREGATED_RATING_COUNT)

  /**
   *  Fields of the "alternative_names"
   * ([AlternativeName][ru.pixnews.igdbclient.model.AlternativeName]) nested IGDB entity
   */
  public val alternative_names: AlternativeNameFieldDsl
    get() = AlternativeNameFieldDsl(fieldWithId(GameField.ALTERNATIVE_NAMES))

  /**
   *  Fields of the "artworks" ([Artwork][ru.pixnews.igdbclient.model.Artwork]) nested IGDB entity
   */
  public val artworks: ArtworkFieldDsl
    get() = ArtworkFieldDsl(fieldWithId(GameField.ARTWORKS))

  /**
   *  Fields of the "bundles" ([Game][Game]) nested IGDB entity
   */
  public val bundles: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameField.BUNDLES))

  /**
   *  Query for the "category" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.category] field of the response
   */
  public val category: IgdbRequestField<Game>
    get() = fieldWithId(GameField.CATEGORY)

  /**
   *  Fields of the "collection" ([Collection][ru.pixnews.igdbclient.model.Collection]) nested IGDB
   * entity
   */
  public val collection: CollectionFieldDsl
    get() = CollectionFieldDsl(fieldWithId(GameField.COLLECTION))

  /**
   *  Fields of the "cover" ([Cover][ru.pixnews.igdbclient.model.Cover]) nested IGDB entity
   */
  public val cover: CoverFieldDsl
    get() = CoverFieldDsl(fieldWithId(GameField.COVER))

  /**
   *  Query for the "created_at" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.created_at] field of the response
   */
  public val created_at: IgdbRequestField<Game>
    get() = fieldWithId(GameField.CREATED_AT)

  /**
   *  Fields of the "dlcs" ([Game][Game]) nested IGDB entity
   */
  public val dlcs: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameField.DLCS))

  /**
   *  Fields of the "expansions" ([Game][Game]) nested IGDB entity
   */
  public val expansions: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameField.EXPANSIONS))

  /**
   *  Fields of the "external_games" ([ExternalGame][ru.pixnews.igdbclient.model.ExternalGame])
   * nested IGDB entity
   */
  public val external_games: ExternalGameFieldDsl
    get() = ExternalGameFieldDsl(fieldWithId(GameField.EXTERNAL_GAMES))

  /**
   *  Query for the "first_release_date" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.first_release_date] field of the response
   */
  public val first_release_date: IgdbRequestField<Game>
    get() = fieldWithId(GameField.FIRST_RELEASE_DATE)

  /**
   *  Query for the "follows" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.follows] field of the response
   */
  public val follows: IgdbRequestField<Game>
    get() = fieldWithId(GameField.FOLLOWS)

  /**
   *  Fields of the "franchise" ([Franchise][ru.pixnews.igdbclient.model.Franchise]) nested IGDB
   * entity
   */
  public val franchise: FranchiseFieldDsl
    get() = FranchiseFieldDsl(fieldWithId(GameField.FRANCHISE))

  /**
   *  Fields of the "franchises" ([Franchise][ru.pixnews.igdbclient.model.Franchise]) nested IGDB
   * entity
   */
  public val franchises: FranchiseFieldDsl
    get() = FranchiseFieldDsl(fieldWithId(GameField.FRANCHISES))

  /**
   *  Fields of the "game_engines" ([GameEngine][ru.pixnews.igdbclient.model.GameEngine]) nested
   * IGDB entity
   */
  public val game_engines: GameEngineFieldDsl
    get() = GameEngineFieldDsl(fieldWithId(GameField.GAME_ENGINES))

  /**
   *  Fields of the "game_modes" ([GameMode][ru.pixnews.igdbclient.model.GameMode]) nested IGDB
   * entity
   */
  public val game_modes: GameModeFieldDsl
    get() = GameModeFieldDsl(fieldWithId(GameField.GAME_MODES))

  /**
   *  Fields of the "genres" ([Genre][ru.pixnews.igdbclient.model.Genre]) nested IGDB entity
   */
  public val genres: GenreFieldDsl
    get() = GenreFieldDsl(fieldWithId(GameField.GENRES))

  /**
   *  Query for the "hypes" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.hypes] field of the response
   */
  public val hypes: IgdbRequestField<Game>
    get() = fieldWithId(GameField.HYPES)

  /**
   *  Fields of the "involved_companies"
   * ([InvolvedCompany][ru.pixnews.igdbclient.model.InvolvedCompany]) nested IGDB entity
   */
  public val involved_companies: InvolvedCompanyFieldDsl
    get() = InvolvedCompanyFieldDsl(fieldWithId(GameField.INVOLVED_COMPANIES))

  /**
   *  Fields of the "keywords" ([Keyword][ru.pixnews.igdbclient.model.Keyword]) nested IGDB entity
   */
  public val keywords: KeywordFieldDsl
    get() = KeywordFieldDsl(fieldWithId(GameField.KEYWORDS))

  /**
   *  Fields of the "multiplayer_modes"
   * ([MultiplayerMode][ru.pixnews.igdbclient.model.MultiplayerMode]) nested IGDB entity
   */
  public val multiplayer_modes: MultiplayerModeFieldDsl
    get() = MultiplayerModeFieldDsl(fieldWithId(GameField.MULTIPLAYER_MODES))

  /**
   *  Query for the "name" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.name] field of the response
   */
  public val name: IgdbRequestField<Game>
    get() = fieldWithId(GameField.NAME)

  /**
   *  Fields of the "parent_game" ([Game][Game]) nested IGDB entity
   */
  public val parent_game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameField.PARENT_GAME))

  /**
   *  Fields of the "platforms" ([Platform][ru.pixnews.igdbclient.model.Platform]) nested IGDB
   * entity
   */
  public val platforms: PlatformFieldDsl
    get() = PlatformFieldDsl(fieldWithId(GameField.PLATFORMS))

  /**
   *  Fields of the "player_perspectives"
   * ([PlayerPerspective][ru.pixnews.igdbclient.model.PlayerPerspective]) nested IGDB entity
   */
  public val player_perspectives: PlayerPerspectiveFieldDsl
    get() = PlayerPerspectiveFieldDsl(fieldWithId(GameField.PLAYER_PERSPECTIVES))

  /**
   *  Query for the "rating" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.rating] field of the response
   */
  public val rating: IgdbRequestField<Game>
    get() = fieldWithId(GameField.RATING)

  /**
   *  Query for the "rating_count" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.rating_count] field of the response
   */
  public val rating_count: IgdbRequestField<Game>
    get() = fieldWithId(GameField.RATING_COUNT)

  /**
   *  Fields of the "release_dates" ([ReleaseDate][ru.pixnews.igdbclient.model.ReleaseDate]) nested
   * IGDB entity
   */
  public val release_dates: ReleaseDateFieldDsl
    get() = ReleaseDateFieldDsl(fieldWithId(GameField.RELEASE_DATES))

  /**
   *  Fields of the "screenshots" ([Screenshot][ru.pixnews.igdbclient.model.Screenshot]) nested IGDB
   * entity
   */
  public val screenshots: ScreenshotFieldDsl
    get() = ScreenshotFieldDsl(fieldWithId(GameField.SCREENSHOTS))

  /**
   *  Fields of the "similar_games" ([Game][Game]) nested IGDB entity
   */
  public val similar_games: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameField.SIMILAR_GAMES))

  /**
   *  Query for the "slug" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.slug] field of the response
   */
  public val slug: IgdbRequestField<Game>
    get() = fieldWithId(GameField.SLUG)

  /**
   *  Fields of the "standalone_expansions" ([Game][Game]) nested IGDB entity
   */
  public val standalone_expansions: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameField.STANDALONE_EXPANSIONS))

  /**
   *  Query for the "status" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.status] field of the response
   */
  public val status: IgdbRequestField<Game>
    get() = fieldWithId(GameField.STATUS)

  /**
   *  Query for the "storyline" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.storyline] field of the response
   */
  public val storyline: IgdbRequestField<Game>
    get() = fieldWithId(GameField.STORYLINE)

  /**
   *  Query for the "summary" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.summary] field of the response
   */
  public val summary: IgdbRequestField<Game>
    get() = fieldWithId(GameField.SUMMARY)

  /**
   *  Query for the "tags" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.tags] field of the response
   */
  public val tags: IgdbRequestField<Game>
    get() = fieldWithId(GameField.TAGS)

  /**
   *  Fields of the "themes" ([Theme][ru.pixnews.igdbclient.model.Theme]) nested IGDB entity
   */
  public val themes: ThemeFieldDsl
    get() = ThemeFieldDsl(fieldWithId(GameField.THEMES))

  /**
   *  Query for the "total_rating" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.total_rating] field of the response
   */
  public val total_rating: IgdbRequestField<Game>
    get() = fieldWithId(GameField.TOTAL_RATING)

  /**
   *  Query for the "total_rating_count" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.total_rating_count] field of the response
   */
  public val total_rating_count: IgdbRequestField<Game>
    get() = fieldWithId(GameField.TOTAL_RATING_COUNT)

  /**
   *  Query for the "updated_at" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<Game>
    get() = fieldWithId(GameField.UPDATED_AT)

  /**
   *  Query for the "url" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.url] field of the response
   */
  public val url: IgdbRequestField<Game>
    get() = fieldWithId(GameField.URL)

  /**
   *  Fields of the "version_parent" ([Game][Game]) nested IGDB entity
   */
  public val version_parent: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameField.VERSION_PARENT))

  /**
   *  Query for the "version_title" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.version_title] field of the response
   */
  public val version_title: IgdbRequestField<Game>
    get() = fieldWithId(GameField.VERSION_TITLE)

  /**
   *  Fields of the "videos" ([GameVideo][ru.pixnews.igdbclient.model.GameVideo]) nested IGDB entity
   */
  public val videos: GameVideoFieldDsl
    get() = GameVideoFieldDsl(fieldWithId(GameField.VIDEOS))

  /**
   *  Fields of the "websites" ([Website][ru.pixnews.igdbclient.model.Website]) nested IGDB entity
   */
  public val websites: WebsiteFieldDsl
    get() = WebsiteFieldDsl(fieldWithId(GameField.WEBSITES))

  /**
   *  Query for the "checksum" field of the [Game] Igdb entity.
   *
   *  The value will be returned in the [Game.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Game>
    get() = fieldWithId(GameField.CHECKSUM)

  /**
   *  Fields of the "remakes" ([Game][Game]) nested IGDB entity
   */
  public val remakes: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameField.REMAKES))

  /**
   *  Fields of the "remasters" ([Game][Game]) nested IGDB entity
   */
  public val remasters: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameField.REMASTERS))

  /**
   *  Fields of the "expanded_games" ([Game][Game]) nested IGDB entity
   */
  public val expanded_games: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameField.EXPANDED_GAMES))

  /**
   *  Fields of the "ports" ([Game][Game]) nested IGDB entity
   */
  public val ports: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameField.PORTS))

  /**
   *  Fields of the "forks" ([Game][Game]) nested IGDB entity
   */
  public val forks: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(GameField.FORKS))

  /**
   *  Fields of the "language_supports"
   * ([LanguageSupport][ru.pixnews.igdbclient.model.LanguageSupport]) nested IGDB entity
   */
  public val language_supports: LanguageSupportFieldDsl
    get() = LanguageSupportFieldDsl(fieldWithId(GameField.LANGUAGE_SUPPORTS))

  /**
   *  Fields of the "game_localizations"
   * ([GameLocalization][ru.pixnews.igdbclient.model.GameLocalization]) nested IGDB entity
   */
  public val game_localizations: GameLocalizationFieldDsl
    get() = GameLocalizationFieldDsl(fieldWithId(GameField.GAME_LOCALIZATIONS))

  /**
   *  Fields of the "collections" ([Collection][ru.pixnews.igdbclient.model.Collection]) nested IGDB
   * entity
   */
  public val collections: CollectionFieldDsl
    get() = CollectionFieldDsl(fieldWithId(GameField.COLLECTIONS))
}
