package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.PopularityType
import ru.pixnews.igdbclient.scheme.`field`.PopularityTypeField

private val _popularityTypeFieldDslInstance: PopularityTypeFieldDsl = PopularityTypeFieldDsl()

public val PopularityType.Companion.`field`: PopularityTypeFieldDsl
  get() = _popularityTypeFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [PopularityType] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#popularity-type](https://api-docs.igdb.com/#popularity-type)
 */
@IgdbClientDsl
public class PopularityTypeFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<PopularityTypeField, PopularityType>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [PopularityType] Igdb entity.
   *
   *  The value will be returned in the [PopularityType.id] field of the response
   */
  public val id: IgdbRequestField<PopularityType>
    get() = fieldWithId(PopularityTypeField.ID)

  /**
   *  Query for the "popularity_source" field of the [PopularityType] Igdb entity.
   *
   *  The value will be returned in the [PopularityType.popularity_source] field of the response
   */
  public val popularity_source: IgdbRequestField<PopularityType>
    get() = fieldWithId(PopularityTypeField.POPULARITY_SOURCE)

  /**
   *  Query for the "name" field of the [PopularityType] Igdb entity.
   *
   *  The value will be returned in the [PopularityType.name] field of the response
   */
  public val name: IgdbRequestField<PopularityType>
    get() = fieldWithId(PopularityTypeField.NAME)

  /**
   *  Query for the "created_at" field of the [PopularityType] Igdb entity.
   *
   *  The value will be returned in the [PopularityType.created_at] field of the response
   */
  public val created_at: IgdbRequestField<PopularityType>
    get() = fieldWithId(PopularityTypeField.CREATED_AT)

  /**
   *  Query for the "updated_at" field of the [PopularityType] Igdb entity.
   *
   *  The value will be returned in the [PopularityType.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<PopularityType>
    get() = fieldWithId(PopularityTypeField.UPDATED_AT)

  /**
   *  Query for the "checksum" field of the [PopularityType] Igdb entity.
   *
   *  The value will be returned in the [PopularityType.checksum] field of the response
   */
  public val checksum: IgdbRequestField<PopularityType>
    get() = fieldWithId(PopularityTypeField.CHECKSUM)
}
