package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Region
import ru.pixnews.igdbclient.scheme.`field`.RegionField

private val _regionFieldDslInstance: RegionFieldDsl = RegionFieldDsl()

public val Region.Companion.`field`: RegionFieldDsl
  get() = _regionFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Region] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#region](https://api-docs.igdb.com/#region)
 */
@IgdbClientDsl
public class RegionFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<RegionField, Region>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Region] Igdb entity.
   *
   *  The value will be returned in the [Region.id] field of the response
   */
  public val id: IgdbRequestField<Region>
    get() = fieldWithId(RegionField.ID)

  /**
   *  Query for the "name" field of the [Region] Igdb entity.
   *
   *  The value will be returned in the [Region.name] field of the response
   */
  public val name: IgdbRequestField<Region>
    get() = fieldWithId(RegionField.NAME)

  /**
   *  Query for the "category" field of the [Region] Igdb entity.
   *
   *  The value will be returned in the [Region.category] field of the response
   */
  public val category: IgdbRequestField<Region>
    get() = fieldWithId(RegionField.CATEGORY)

  /**
   *  Query for the "identifier" field of the [Region] Igdb entity.
   *
   *  The value will be returned in the [Region.identifier] field of the response
   */
  public val identifier: IgdbRequestField<Region>
    get() = fieldWithId(RegionField.IDENTIFIER)

  /**
   *  Query for the "created_at" field of the [Region] Igdb entity.
   *
   *  The value will be returned in the [Region.created_at] field of the response
   */
  public val created_at: IgdbRequestField<Region>
    get() = fieldWithId(RegionField.CREATED_AT)

  /**
   *  Query for the "updated_at" field of the [Region] Igdb entity.
   *
   *  The value will be returned in the [Region.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<Region>
    get() = fieldWithId(RegionField.UPDATED_AT)

  /**
   *  Query for the "checksum" field of the [Region] Igdb entity.
   *
   *  The value will be returned in the [Region.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Region>
    get() = fieldWithId(RegionField.CHECKSUM)
}
