package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Language

/**
 *  Fields of the [Language] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#language](https://api-docs.igdb.com/#language)
 */
public enum class LanguageField(
  public override val igdbName: String,
) : IgdbField<Language> {
  /**
   *  Field "id" of the [Language] IGDB entity. Matches [Language.id].
   */
  ID("id"),
  /**
   *  Field "name" of the [Language] IGDB entity. Matches [Language.name].
   */
  NAME("name"),
  /**
   *  Field "native_name" of the [Language] IGDB entity. Matches [Language.native_name].
   */
  NATIVE_NAME("native_name"),
  /**
   *  Field "locale" of the [Language] IGDB entity. Matches [Language.locale].
   */
  LOCALE("locale"),
  /**
   *  Field "created_at" of the [Language] IGDB entity. Matches [Language.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "updated_at" of the [Language] IGDB entity. Matches [Language.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "checksum" of the [Language] IGDB entity. Matches [Language.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
