package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.CollectionType
import ru.pixnews.igdbclient.scheme.`field`.CollectionTypeField

private val _collectionTypeFieldDslInstance: CollectionTypeFieldDsl = CollectionTypeFieldDsl()

public val CollectionType.Companion.`field`: CollectionTypeFieldDsl
  get() = _collectionTypeFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [CollectionType] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#collection-type](https://api-docs.igdb.com/#collection-type)
 */
@IgdbClientDsl
public class CollectionTypeFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<CollectionTypeField, CollectionType>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [CollectionType] Igdb entity.
   *
   *  The value will be returned in the [CollectionType.id] field of the response
   */
  public val id: IgdbRequestField<CollectionType>
    get() = fieldWithId(CollectionTypeField.ID)

  /**
   *  Query for the "name" field of the [CollectionType] Igdb entity.
   *
   *  The value will be returned in the [CollectionType.name] field of the response
   */
  public val name: IgdbRequestField<CollectionType>
    get() = fieldWithId(CollectionTypeField.NAME)

  /**
   *  Query for the "description" field of the [CollectionType] Igdb entity.
   *
   *  The value will be returned in the [CollectionType.description] field of the response
   */
  public val description: IgdbRequestField<CollectionType>
    get() = fieldWithId(CollectionTypeField.DESCRIPTION)

  /**
   *  Query for the "updated_at" field of the [CollectionType] Igdb entity.
   *
   *  The value will be returned in the [CollectionType.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<CollectionType>
    get() = fieldWithId(CollectionTypeField.UPDATED_AT)

  /**
   *  Query for the "created_at" field of the [CollectionType] Igdb entity.
   *
   *  The value will be returned in the [CollectionType.created_at] field of the response
   */
  public val created_at: IgdbRequestField<CollectionType>
    get() = fieldWithId(CollectionTypeField.CREATED_AT)

  /**
   *  Query for the "checksum" field of the [CollectionType] Igdb entity.
   *
   *  The value will be returned in the [CollectionType.checksum] field of the response
   */
  public val checksum: IgdbRequestField<CollectionType>
    get() = fieldWithId(CollectionTypeField.CHECKSUM)
}
