package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.LanguageSupportType
import ru.pixnews.igdbclient.scheme.`field`.LanguageSupportTypeField

private val _languageSupportTypeFieldDslInstance: LanguageSupportTypeFieldDsl =
    LanguageSupportTypeFieldDsl()

public val LanguageSupportType.Companion.`field`: LanguageSupportTypeFieldDsl
  get() = _languageSupportTypeFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [LanguageSupportType] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#language-support-type](https://api-docs.igdb.com/#language-support-type)
 */
@IgdbClientDsl
public class LanguageSupportTypeFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<LanguageSupportTypeField, LanguageSupportType>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [LanguageSupportType] Igdb entity.
   *
   *  The value will be returned in the [LanguageSupportType.id] field of the response
   */
  public val id: IgdbRequestField<LanguageSupportType>
    get() = fieldWithId(LanguageSupportTypeField.ID)

  /**
   *  Query for the "name" field of the [LanguageSupportType] Igdb entity.
   *
   *  The value will be returned in the [LanguageSupportType.name] field of the response
   */
  public val name: IgdbRequestField<LanguageSupportType>
    get() = fieldWithId(LanguageSupportTypeField.NAME)

  /**
   *  Query for the "created_at" field of the [LanguageSupportType] Igdb entity.
   *
   *  The value will be returned in the [LanguageSupportType.created_at] field of the response
   */
  public val created_at: IgdbRequestField<LanguageSupportType>
    get() = fieldWithId(LanguageSupportTypeField.CREATED_AT)

  /**
   *  Query for the "updated_at" field of the [LanguageSupportType] Igdb entity.
   *
   *  The value will be returned in the [LanguageSupportType.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<LanguageSupportType>
    get() = fieldWithId(LanguageSupportTypeField.UPDATED_AT)

  /**
   *  Query for the "checksum" field of the [LanguageSupportType] Igdb entity.
   *
   *  The value will be returned in the [LanguageSupportType.checksum] field of the response
   */
  public val checksum: IgdbRequestField<LanguageSupportType>
    get() = fieldWithId(LanguageSupportTypeField.CHECKSUM)
}
