package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Screenshot
import ru.pixnews.igdbclient.scheme.`field`.ScreenshotField

private val _screenshotFieldDslInstance: ScreenshotFieldDsl = ScreenshotFieldDsl()

public val Screenshot.Companion.`field`: ScreenshotFieldDsl
  get() = _screenshotFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Screenshot] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#screenshot](https://api-docs.igdb.com/#screenshot)
 */
@IgdbClientDsl
public class ScreenshotFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<ScreenshotField, Screenshot>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Screenshot] Igdb entity.
   *
   *  The value will be returned in the [Screenshot.id] field of the response
   */
  public val id: IgdbRequestField<Screenshot>
    get() = fieldWithId(ScreenshotField.ID)

  /**
   *  Query for the "alpha_channel" field of the [Screenshot] Igdb entity.
   *
   *  The value will be returned in the [Screenshot.alpha_channel] field of the response
   */
  public val alpha_channel: IgdbRequestField<Screenshot>
    get() = fieldWithId(ScreenshotField.ALPHA_CHANNEL)

  /**
   *  Query for the "animated" field of the [Screenshot] Igdb entity.
   *
   *  The value will be returned in the [Screenshot.animated] field of the response
   */
  public val animated: IgdbRequestField<Screenshot>
    get() = fieldWithId(ScreenshotField.ANIMATED)

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(ScreenshotField.GAME))

  /**
   *  Query for the "height" field of the [Screenshot] Igdb entity.
   *
   *  The value will be returned in the [Screenshot.height] field of the response
   */
  public val height: IgdbRequestField<Screenshot>
    get() = fieldWithId(ScreenshotField.HEIGHT)

  /**
   *  Query for the "image_id" field of the [Screenshot] Igdb entity.
   *
   *  The value will be returned in the [Screenshot.image_id] field of the response
   */
  public val image_id: IgdbRequestField<Screenshot>
    get() = fieldWithId(ScreenshotField.IMAGE_ID)

  /**
   *  Query for the "url" field of the [Screenshot] Igdb entity.
   *
   *  The value will be returned in the [Screenshot.url] field of the response
   */
  public val url: IgdbRequestField<Screenshot>
    get() = fieldWithId(ScreenshotField.URL)

  /**
   *  Query for the "width" field of the [Screenshot] Igdb entity.
   *
   *  The value will be returned in the [Screenshot.width] field of the response
   */
  public val width: IgdbRequestField<Screenshot>
    get() = fieldWithId(ScreenshotField.WIDTH)

  /**
   *  Query for the "checksum" field of the [Screenshot] Igdb entity.
   *
   *  The value will be returned in the [Screenshot.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Screenshot>
    get() = fieldWithId(ScreenshotField.CHECKSUM)
}
