package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Screenshot

/**
 *  Fields of the [Screenshot] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#screenshot](https://api-docs.igdb.com/#screenshot)
 */
public enum class ScreenshotField(
  public override val igdbName: String,
) : IgdbField<Screenshot> {
  /**
   *  Field "id" of the [Screenshot] IGDB entity. Matches [Screenshot.id].
   */
  ID("id"),
  /**
   *  Field "alpha_channel" of the [Screenshot] IGDB entity. Matches [Screenshot.alpha_channel].
   */
  ALPHA_CHANNEL("alpha_channel"),
  /**
   *  Field "animated" of the [Screenshot] IGDB entity. Matches [Screenshot.animated].
   */
  ANIMATED("animated"),
  /**
   *  Field "game" of the [Screenshot] IGDB entity. Matches [Screenshot.game].
   */
  GAME("game"),
  /**
   *  Field "height" of the [Screenshot] IGDB entity. Matches [Screenshot.height].
   */
  HEIGHT("height"),
  /**
   *  Field "image_id" of the [Screenshot] IGDB entity. Matches [Screenshot.image_id].
   */
  IMAGE_ID("image_id"),
  /**
   *  Field "url" of the [Screenshot] IGDB entity. Matches [Screenshot.url].
   */
  URL("url"),
  /**
   *  Field "width" of the [Screenshot] IGDB entity. Matches [Screenshot.width].
   */
  WIDTH("width"),
  /**
   *  Field "checksum" of the [Screenshot] IGDB entity. Matches [Screenshot.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
