package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.GameEngineLogo
import ru.pixnews.igdbclient.scheme.`field`.GameEngineLogoField

private val _gameEngineLogoFieldDslInstance: GameEngineLogoFieldDsl = GameEngineLogoFieldDsl()

public val GameEngineLogo.Companion.`field`: GameEngineLogoFieldDsl
  get() = _gameEngineLogoFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [GameEngineLogo] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#game-engine-logo](https://api-docs.igdb.com/#game-engine-logo)
 */
@IgdbClientDsl
public class GameEngineLogoFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<GameEngineLogoField, GameEngineLogo>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [GameEngineLogo] Igdb entity.
   *
   *  The value will be returned in the [GameEngineLogo.id] field of the response
   */
  public val id: IgdbRequestField<GameEngineLogo>
    get() = fieldWithId(GameEngineLogoField.ID)

  /**
   *  Query for the "alpha_channel" field of the [GameEngineLogo] Igdb entity.
   *
   *  The value will be returned in the [GameEngineLogo.alpha_channel] field of the response
   */
  public val alpha_channel: IgdbRequestField<GameEngineLogo>
    get() = fieldWithId(GameEngineLogoField.ALPHA_CHANNEL)

  /**
   *  Query for the "animated" field of the [GameEngineLogo] Igdb entity.
   *
   *  The value will be returned in the [GameEngineLogo.animated] field of the response
   */
  public val animated: IgdbRequestField<GameEngineLogo>
    get() = fieldWithId(GameEngineLogoField.ANIMATED)

  /**
   *  Query for the "height" field of the [GameEngineLogo] Igdb entity.
   *
   *  The value will be returned in the [GameEngineLogo.height] field of the response
   */
  public val height: IgdbRequestField<GameEngineLogo>
    get() = fieldWithId(GameEngineLogoField.HEIGHT)

  /**
   *  Query for the "image_id" field of the [GameEngineLogo] Igdb entity.
   *
   *  The value will be returned in the [GameEngineLogo.image_id] field of the response
   */
  public val image_id: IgdbRequestField<GameEngineLogo>
    get() = fieldWithId(GameEngineLogoField.IMAGE_ID)

  /**
   *  Query for the "url" field of the [GameEngineLogo] Igdb entity.
   *
   *  The value will be returned in the [GameEngineLogo.url] field of the response
   */
  public val url: IgdbRequestField<GameEngineLogo>
    get() = fieldWithId(GameEngineLogoField.URL)

  /**
   *  Query for the "width" field of the [GameEngineLogo] Igdb entity.
   *
   *  The value will be returned in the [GameEngineLogo.width] field of the response
   */
  public val width: IgdbRequestField<GameEngineLogo>
    get() = fieldWithId(GameEngineLogoField.WIDTH)

  /**
   *  Query for the "checksum" field of the [GameEngineLogo] Igdb entity.
   *
   *  The value will be returned in the [GameEngineLogo.checksum] field of the response
   */
  public val checksum: IgdbRequestField<GameEngineLogo>
    get() = fieldWithId(GameEngineLogoField.CHECKSUM)
}
