package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Language
import ru.pixnews.igdbclient.scheme.`field`.LanguageField

private val _languageFieldDslInstance: LanguageFieldDsl = LanguageFieldDsl()

public val Language.Companion.`field`: LanguageFieldDsl
  get() = _languageFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Language] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#language](https://api-docs.igdb.com/#language)
 */
@IgdbClientDsl
public class LanguageFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<LanguageField, Language>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Language] Igdb entity.
   *
   *  The value will be returned in the [Language.id] field of the response
   */
  public val id: IgdbRequestField<Language>
    get() = fieldWithId(LanguageField.ID)

  /**
   *  Query for the "name" field of the [Language] Igdb entity.
   *
   *  The value will be returned in the [Language.name] field of the response
   */
  public val name: IgdbRequestField<Language>
    get() = fieldWithId(LanguageField.NAME)

  /**
   *  Query for the "native_name" field of the [Language] Igdb entity.
   *
   *  The value will be returned in the [Language.native_name] field of the response
   */
  public val native_name: IgdbRequestField<Language>
    get() = fieldWithId(LanguageField.NATIVE_NAME)

  /**
   *  Query for the "locale" field of the [Language] Igdb entity.
   *
   *  The value will be returned in the [Language.locale] field of the response
   */
  public val locale: IgdbRequestField<Language>
    get() = fieldWithId(LanguageField.LOCALE)

  /**
   *  Query for the "created_at" field of the [Language] Igdb entity.
   *
   *  The value will be returned in the [Language.created_at] field of the response
   */
  public val created_at: IgdbRequestField<Language>
    get() = fieldWithId(LanguageField.CREATED_AT)

  /**
   *  Query for the "updated_at" field of the [Language] Igdb entity.
   *
   *  The value will be returned in the [Language.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<Language>
    get() = fieldWithId(LanguageField.UPDATED_AT)

  /**
   *  Query for the "checksum" field of the [Language] Igdb entity.
   *
   *  The value will be returned in the [Language.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Language>
    get() = fieldWithId(LanguageField.CHECKSUM)
}
