package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Character

/**
 *  Fields of the [Character] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#character](https://api-docs.igdb.com/#character)
 */
public enum class CharacterField(
  public override val igdbName: String,
) : IgdbField<Character> {
  /**
   *  Field "id" of the [Character] IGDB entity. Matches [Character.id].
   */
  ID("id"),
  /**
   *  Field "akas" of the [Character] IGDB entity. Matches [Character.akas].
   */
  AKAS("akas"),
  /**
   *  Field "country_name" of the [Character] IGDB entity. Matches [Character.country_name].
   */
  COUNTRY_NAME("country_name"),
  /**
   *  Field "created_at" of the [Character] IGDB entity. Matches [Character.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "description" of the [Character] IGDB entity. Matches [Character.description].
   */
  DESCRIPTION("description"),
  /**
   *  Field "games" of the [Character] IGDB entity. Matches [Character.games].
   */
  GAMES("games"),
  /**
   *  Field "gender" of the [Character] IGDB entity. Matches [Character.gender].
   */
  GENDER("gender"),
  /**
   *  Field "mug_shot" of the [Character] IGDB entity. Matches [Character.mug_shot].
   */
  MUG_SHOT("mug_shot"),
  /**
   *  Field "name" of the [Character] IGDB entity. Matches [Character.name].
   */
  NAME("name"),
  /**
   *  Field "slug" of the [Character] IGDB entity. Matches [Character.slug].
   */
  SLUG("slug"),
  /**
   *  Field "species" of the [Character] IGDB entity. Matches [Character.species].
   */
  SPECIES("species"),
  /**
   *  Field "updated_at" of the [Character] IGDB entity. Matches [Character.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "url" of the [Character] IGDB entity. Matches [Character.url].
   */
  URL("url"),
  /**
   *  Field "checksum" of the [Character] IGDB entity. Matches [Character.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
