package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.CollectionMembership

/**
 *  Fields of the [CollectionMembership] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#collection-membership](https://api-docs.igdb.com/#collection-membership)
 */
public enum class CollectionMembershipField(
  public override val igdbName: String,
) : IgdbField<CollectionMembership> {
  /**
   *  Field "id" of the [CollectionMembership] IGDB entity. Matches [CollectionMembership.id].
   */
  ID("id"),
  /**
   *  Field "game" of the [CollectionMembership] IGDB entity. Matches [CollectionMembership.game].
   */
  GAME("game"),
  /**
   *  Field "collection" of the [CollectionMembership] IGDB entity. Matches
   * [CollectionMembership.collection].
   */
  COLLECTION("collection"),
  /**
   *  Field "type" of the [CollectionMembership] IGDB entity. Matches [CollectionMembership.type].
   */
  TYPE("type"),
  /**
   *  Field "updated_at" of the [CollectionMembership] IGDB entity. Matches
   * [CollectionMembership.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "created_at" of the [CollectionMembership] IGDB entity. Matches
   * [CollectionMembership.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "checksum" of the [CollectionMembership] IGDB entity. Matches
   * [CollectionMembership.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
