package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.CollectionMembershipType

/**
 *  Fields of the [CollectionMembershipType] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#collection-membership-type](https://api-docs.igdb.com/#collection-membership-type)
 */
public enum class CollectionMembershipTypeField(
  public override val igdbName: String,
) : IgdbField<CollectionMembershipType> {
  /**
   *  Field "id" of the [CollectionMembershipType] IGDB entity. Matches
   * [CollectionMembershipType.id].
   */
  ID("id"),
  /**
   *  Field "name" of the [CollectionMembershipType] IGDB entity. Matches
   * [CollectionMembershipType.name].
   */
  NAME("name"),
  /**
   *  Field "description" of the [CollectionMembershipType] IGDB entity. Matches
   * [CollectionMembershipType.description].
   */
  DESCRIPTION("description"),
  /**
   *  Field "allowed_collection_type" of the [CollectionMembershipType] IGDB entity. Matches
   * [CollectionMembershipType.allowed_collection_type].
   */
  ALLOWED_COLLECTION_TYPE("allowed_collection_type"),
  /**
   *  Field "updated_at" of the [CollectionMembershipType] IGDB entity. Matches
   * [CollectionMembershipType.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "created_at" of the [CollectionMembershipType] IGDB entity. Matches
   * [CollectionMembershipType.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "checksum" of the [CollectionMembershipType] IGDB entity. Matches
   * [CollectionMembershipType.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
