package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Character
import ru.pixnews.igdbclient.scheme.`field`.CharacterField

private val _characterFieldDslInstance: CharacterFieldDsl = CharacterFieldDsl()

public val Character.Companion.`field`: CharacterFieldDsl
  get() = _characterFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Character] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#character](https://api-docs.igdb.com/#character)
 */
@IgdbClientDsl
public class CharacterFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<CharacterField, Character>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Character] Igdb entity.
   *
   *  The value will be returned in the [Character.id] field of the response
   */
  public val id: IgdbRequestField<Character>
    get() = fieldWithId(CharacterField.ID)

  /**
   *  Query for the "akas" field of the [Character] Igdb entity.
   *
   *  The value will be returned in the [Character.akas] field of the response
   */
  public val akas: IgdbRequestField<Character>
    get() = fieldWithId(CharacterField.AKAS)

  /**
   *  Query for the "country_name" field of the [Character] Igdb entity.
   *
   *  The value will be returned in the [Character.country_name] field of the response
   */
  public val country_name: IgdbRequestField<Character>
    get() = fieldWithId(CharacterField.COUNTRY_NAME)

  /**
   *  Query for the "created_at" field of the [Character] Igdb entity.
   *
   *  The value will be returned in the [Character.created_at] field of the response
   */
  public val created_at: IgdbRequestField<Character>
    get() = fieldWithId(CharacterField.CREATED_AT)

  /**
   *  Query for the "description" field of the [Character] Igdb entity.
   *
   *  The value will be returned in the [Character.description] field of the response
   */
  public val description: IgdbRequestField<Character>
    get() = fieldWithId(CharacterField.DESCRIPTION)

  /**
   *  Fields of the "games" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val games: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(CharacterField.GAMES))

  /**
   *  Query for the "gender" field of the [Character] Igdb entity.
   *
   *  The value will be returned in the [Character.gender] field of the response
   */
  public val gender: IgdbRequestField<Character>
    get() = fieldWithId(CharacterField.GENDER)

  /**
   *  Fields of the "mug_shot" ([CharacterMugShot][ru.pixnews.igdbclient.model.CharacterMugShot])
   * nested IGDB entity
   */
  public val mug_shot: CharacterMugShotFieldDsl
    get() = CharacterMugShotFieldDsl(fieldWithId(CharacterField.MUG_SHOT))

  /**
   *  Query for the "name" field of the [Character] Igdb entity.
   *
   *  The value will be returned in the [Character.name] field of the response
   */
  public val name: IgdbRequestField<Character>
    get() = fieldWithId(CharacterField.NAME)

  /**
   *  Query for the "slug" field of the [Character] Igdb entity.
   *
   *  The value will be returned in the [Character.slug] field of the response
   */
  public val slug: IgdbRequestField<Character>
    get() = fieldWithId(CharacterField.SLUG)

  /**
   *  Query for the "species" field of the [Character] Igdb entity.
   *
   *  The value will be returned in the [Character.species] field of the response
   */
  public val species: IgdbRequestField<Character>
    get() = fieldWithId(CharacterField.SPECIES)

  /**
   *  Query for the "updated_at" field of the [Character] Igdb entity.
   *
   *  The value will be returned in the [Character.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<Character>
    get() = fieldWithId(CharacterField.UPDATED_AT)

  /**
   *  Query for the "url" field of the [Character] Igdb entity.
   *
   *  The value will be returned in the [Character.url] field of the response
   */
  public val url: IgdbRequestField<Character>
    get() = fieldWithId(CharacterField.URL)

  /**
   *  Query for the "checksum" field of the [Character] Igdb entity.
   *
   *  The value will be returned in the [Character.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Character>
    get() = fieldWithId(CharacterField.CHECKSUM)
}
