package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.CharacterMugShot
import ru.pixnews.igdbclient.scheme.`field`.CharacterMugShotField

private val _characterMugShotFieldDslInstance: CharacterMugShotFieldDsl = CharacterMugShotFieldDsl()

public val CharacterMugShot.Companion.`field`: CharacterMugShotFieldDsl
  get() = _characterMugShotFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [CharacterMugShot] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#character-mug-shot](https://api-docs.igdb.com/#character-mug-shot)
 */
@IgdbClientDsl
public class CharacterMugShotFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<CharacterMugShotField, CharacterMugShot>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [CharacterMugShot] Igdb entity.
   *
   *  The value will be returned in the [CharacterMugShot.id] field of the response
   */
  public val id: IgdbRequestField<CharacterMugShot>
    get() = fieldWithId(CharacterMugShotField.ID)

  /**
   *  Query for the "alpha_channel" field of the [CharacterMugShot] Igdb entity.
   *
   *  The value will be returned in the [CharacterMugShot.alpha_channel] field of the response
   */
  public val alpha_channel: IgdbRequestField<CharacterMugShot>
    get() = fieldWithId(CharacterMugShotField.ALPHA_CHANNEL)

  /**
   *  Query for the "animated" field of the [CharacterMugShot] Igdb entity.
   *
   *  The value will be returned in the [CharacterMugShot.animated] field of the response
   */
  public val animated: IgdbRequestField<CharacterMugShot>
    get() = fieldWithId(CharacterMugShotField.ANIMATED)

  /**
   *  Query for the "height" field of the [CharacterMugShot] Igdb entity.
   *
   *  The value will be returned in the [CharacterMugShot.height] field of the response
   */
  public val height: IgdbRequestField<CharacterMugShot>
    get() = fieldWithId(CharacterMugShotField.HEIGHT)

  /**
   *  Query for the "image_id" field of the [CharacterMugShot] Igdb entity.
   *
   *  The value will be returned in the [CharacterMugShot.image_id] field of the response
   */
  public val image_id: IgdbRequestField<CharacterMugShot>
    get() = fieldWithId(CharacterMugShotField.IMAGE_ID)

  /**
   *  Query for the "url" field of the [CharacterMugShot] Igdb entity.
   *
   *  The value will be returned in the [CharacterMugShot.url] field of the response
   */
  public val url: IgdbRequestField<CharacterMugShot>
    get() = fieldWithId(CharacterMugShotField.URL)

  /**
   *  Query for the "width" field of the [CharacterMugShot] Igdb entity.
   *
   *  The value will be returned in the [CharacterMugShot.width] field of the response
   */
  public val width: IgdbRequestField<CharacterMugShot>
    get() = fieldWithId(CharacterMugShotField.WIDTH)

  /**
   *  Query for the "checksum" field of the [CharacterMugShot] Igdb entity.
   *
   *  The value will be returned in the [CharacterMugShot.checksum] field of the response
   */
  public val checksum: IgdbRequestField<CharacterMugShot>
    get() = fieldWithId(CharacterMugShotField.CHECKSUM)
}
