package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.GameEngineLogo

/**
 *  Fields of the [GameEngineLogo] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#game-engine-logo](https://api-docs.igdb.com/#game-engine-logo)
 */
public enum class GameEngineLogoField(
  public override val igdbName: String,
) : IgdbField<GameEngineLogo> {
  /**
   *  Field "id" of the [GameEngineLogo] IGDB entity. Matches [GameEngineLogo.id].
   */
  ID("id"),
  /**
   *  Field "alpha_channel" of the [GameEngineLogo] IGDB entity. Matches
   * [GameEngineLogo.alpha_channel].
   */
  ALPHA_CHANNEL("alpha_channel"),
  /**
   *  Field "animated" of the [GameEngineLogo] IGDB entity. Matches [GameEngineLogo.animated].
   */
  ANIMATED("animated"),
  /**
   *  Field "height" of the [GameEngineLogo] IGDB entity. Matches [GameEngineLogo.height].
   */
  HEIGHT("height"),
  /**
   *  Field "image_id" of the [GameEngineLogo] IGDB entity. Matches [GameEngineLogo.image_id].
   */
  IMAGE_ID("image_id"),
  /**
   *  Field "url" of the [GameEngineLogo] IGDB entity. Matches [GameEngineLogo.url].
   */
  URL("url"),
  /**
   *  Field "width" of the [GameEngineLogo] IGDB entity. Matches [GameEngineLogo.width].
   */
  WIDTH("width"),
  /**
   *  Field "checksum" of the [GameEngineLogo] IGDB entity. Matches [GameEngineLogo.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
