package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.GameVersionFeature

/**
 *  Fields of the [GameVersionFeature] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#game-version-feature](https://api-docs.igdb.com/#game-version-feature)
 */
public enum class GameVersionFeatureField(
  public override val igdbName: String,
) : IgdbField<GameVersionFeature> {
  /**
   *  Field "id" of the [GameVersionFeature] IGDB entity. Matches [GameVersionFeature.id].
   */
  ID("id"),
  /**
   *  Field "category" of the [GameVersionFeature] IGDB entity. Matches
   * [GameVersionFeature.category].
   */
  CATEGORY("category"),
  /**
   *  Field "description" of the [GameVersionFeature] IGDB entity. Matches
   * [GameVersionFeature.description].
   */
  DESCRIPTION("description"),
  /**
   *  Field "position" of the [GameVersionFeature] IGDB entity. Matches
   * [GameVersionFeature.position].
   */
  POSITION("position"),
  /**
   *  Field "title" of the [GameVersionFeature] IGDB entity. Matches [GameVersionFeature.title].
   */
  TITLE("title"),
  /**
   *  Field "values" of the [GameVersionFeature] IGDB entity. Matches [GameVersionFeature.values].
   */
  VALUES("values"),
  /**
   *  Field "checksum" of the [GameVersionFeature] IGDB entity. Matches
   * [GameVersionFeature.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
