package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.PlatformVersion

/**
 *  Fields of the [PlatformVersion] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#platform-version](https://api-docs.igdb.com/#platform-version)
 */
public enum class PlatformVersionField(
  public override val igdbName: String,
) : IgdbField<PlatformVersion> {
  /**
   *  Field "id" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.id].
   */
  ID("id"),
  /**
   *  Field "companies" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.companies].
   */
  COMPANIES("companies"),
  /**
   *  Field "connectivity" of the [PlatformVersion] IGDB entity. Matches
   * [PlatformVersion.connectivity].
   */
  CONNECTIVITY("connectivity"),
  /**
   *  Field "cpu" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.cpu].
   */
  CPU("cpu"),
  /**
   *  Field "graphics" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.graphics].
   */
  GRAPHICS("graphics"),
  /**
   *  Field "main_manufacturer" of the [PlatformVersion] IGDB entity. Matches
   * [PlatformVersion.main_manufacturer].
   */
  MAIN_MANUFACTURER("main_manufacturer"),
  /**
   *  Field "media" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.media].
   */
  MEDIA("media"),
  /**
   *  Field "memory" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.memory].
   */
  MEMORY("memory"),
  /**
   *  Field "name" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.name].
   */
  NAME("name"),
  /**
   *  Field "online" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.online].
   */
  ONLINE("online"),
  /**
   *  Field "os" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.os].
   */
  OS("os"),
  /**
   *  Field "output" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.output].
   */
  OUTPUT("output"),
  /**
   *  Field "platform_logo" of the [PlatformVersion] IGDB entity. Matches
   * [PlatformVersion.platform_logo].
   */
  PLATFORM_LOGO("platform_logo"),
  /**
   *  Field "platform_version_release_dates" of the [PlatformVersion] IGDB entity. Matches
   * [PlatformVersion.platform_version_release_dates].
   */
  PLATFORM_VERSION_RELEASE_DATES("platform_version_release_dates"),
  /**
   *  Field "resolutions" of the [PlatformVersion] IGDB entity. Matches
   * [PlatformVersion.resolutions].
   */
  RESOLUTIONS("resolutions"),
  /**
   *  Field "slug" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.slug].
   */
  SLUG("slug"),
  /**
   *  Field "sound" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.sound].
   */
  SOUND("sound"),
  /**
   *  Field "storage" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.storage].
   */
  STORAGE("storage"),
  /**
   *  Field "summary" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.summary].
   */
  SUMMARY("summary"),
  /**
   *  Field "url" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.url].
   */
  URL("url"),
  /**
   *  Field "checksum" of the [PlatformVersion] IGDB entity. Matches [PlatformVersion.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
